/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import java.util.Map;

public final class ContextVisitors {
    private static final MapContextVisitor<?> MAP_CONTEXT_VISITOR = new MapContextVisitor();
    private static final EntrySetContextVisitor<?> ENTRY_SET_CONTEXT_VISITOR = new EntrySetContextVisitor();

    public static <T extends Map<String, ?>> AgentPropagation.ContextVisitor<T> objectValuesMap() {
        return MAP_CONTEXT_VISITOR;
    }

    public static <T extends Map<String, String>> AgentPropagation.ContextVisitor<T> stringValuesMap() {
        return MAP_CONTEXT_VISITOR;
    }

    public static <T extends Iterable<Map.Entry<String, ?>>> AgentPropagation.ContextVisitor<T> objectValuesEntrySet() {
        return ENTRY_SET_CONTEXT_VISITOR;
    }

    public static <T extends Iterable<Map.Entry<String, String>>> AgentPropagation.ContextVisitor<T> stringValuesEntrySet() {
        return ENTRY_SET_CONTEXT_VISITOR;
    }

    private static final class EntrySetContextVisitor<T extends Iterable<Map.Entry<String, ?>>>
    implements AgentPropagation.ContextVisitor<T> {
        private EntrySetContextVisitor() {
        }

        @Override
        public void forEachKey(T carrier, AgentPropagation.KeyClassifier classifier) {
            for (Map.Entry entry : carrier) {
                if (null == entry.getValue() || classifier.accept((String)entry.getKey(), entry.getValue().toString())) continue;
                return;
            }
        }
    }

    private static final class MapContextVisitor<T extends Map<String, ?>>
    implements AgentPropagation.ContextVisitor<T> {
        private MapContextVisitor() {
        }

        @Override
        public void forEachKey(T carrier, AgentPropagation.KeyClassifier classifier) {
            for (Map.Entry entry : carrier.entrySet()) {
                if (null == entry.getValue() || classifier.accept((String)entry.getKey(), entry.getValue().toString())) continue;
                return;
            }
        }
    }
}

