/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.debugger;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.config.provider.ConfigProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public final class CorrelationAccess {
    private static final Logger log = LoggerFactory.getLogger(CorrelationAccess.class);
    private static final String CORRELATION_IDENTIFIER_CLASSNAME = "datadog/trace/api/CorrelationIdentifier".replace('/', '.');
    private static volatile boolean REUSE_INSTANCE = true;
    private final MethodHandle traceIdHandle;
    private final MethodHandle spanIdHandle;

    private CorrelationAccess() {
        MethodHandle traceIdHandle = null;
        MethodHandle spanIdHandle = null;
        if (ConfigProvider.getInstance().getBoolean("trace.enabled", true, new String[0])) {
            try {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(CORRELATION_IDENTIFIER_CLASSNAME);
                traceIdHandle = MethodHandles.publicLookup().findStatic(clz, "getTraceId", MethodType.methodType(String.class));
                spanIdHandle = MethodHandles.publicLookup().findStatic(clz, "getSpanId", MethodType.methodType(String.class));
            }
            catch (Throwable t) {
                if (log.isDebugEnabled()) {
                    log.debug("Unable to initialize tracer correlation access: {}", (Object)t.toString());
                }
                traceIdHandle = null;
                spanIdHandle = null;
            }
        }
        this.traceIdHandle = traceIdHandle;
        this.spanIdHandle = spanIdHandle;
    }

    CorrelationAccess(MethodHandle traceIdHandle, MethodHandle spanIdHandle) {
        this.traceIdHandle = traceIdHandle;
        this.spanIdHandle = spanIdHandle;
    }

    public static CorrelationAccess instance() {
        return REUSE_INSTANCE ? Singleton.INSTANCE : new CorrelationAccess();
    }

    public boolean isAvailable() {
        return this.traceIdHandle != null && this.spanIdHandle != null;
    }

    public String getSpanId() {
        try {
            return this.isAvailable() ? this.spanIdHandle.invokeExact() : null;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to get tracer span id: {}", (Object)t.toString());
            }
            return null;
        }
    }

    public String getTraceId() {
        try {
            return this.isAvailable() ? this.traceIdHandle.invokeExact() : null;
        }
        catch (Throwable t) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to get tracer trace id: {}", (Object)t.toString());
            }
            return null;
        }
    }

    private static class Singleton {
        private static final CorrelationAccess INSTANCE = new CorrelationAccess();

        private Singleton() {
        }
    }
}

