/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.telemetry;

import datadog.trace.api.telemetry.ProductChange;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class ProductChangeCollector {
    private static final ProductChangeCollector INSTANCE = new ProductChangeCollector();
    private final Queue<ProductChange> productChanges = new LinkedBlockingQueue<ProductChange>();

    private ProductChangeCollector() {
    }

    public static ProductChangeCollector get() {
        return INSTANCE;
    }

    public synchronized void update(ProductChange productChange) {
        this.productChanges.offer(productChange);
    }

    public synchronized List<ProductChange> drain() {
        ProductChange productChange;
        if (this.productChanges.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<ProductChange> list = new LinkedList<ProductChange>();
        while ((productChange = this.productChanges.poll()) != null) {
            list.add(productChange);
        }
        return list;
    }
}

