/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.env;

import datadog.environment.JavaVirtualMachine;
import datadog.trace.config.inversion.ConfigHelper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class CapturedEnvironment {
    private static final CapturedEnvironment INSTANCE = new CapturedEnvironment();
    private final Map<String, String> properties = new HashMap<String, String>();
    private ProcessInfo processInfo = new ProcessInfo();

    private CapturedEnvironment() {
        this.properties.put("service.name", this.autodetectServiceName());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public ProcessInfo getProcessInfo() {
        return this.processInfo;
    }

    static void useFixedEnv(Map<String, String> props) {
        CapturedEnvironment.INSTANCE.properties.clear();
        CapturedEnvironment.INSTANCE.properties.putAll(props);
    }

    static void useFixedProcessInfo(ProcessInfo processInfo) {
        CapturedEnvironment.INSTANCE.processInfo = processInfo;
    }

    private String autodetectServiceName() {
        String inAas = ConfigHelper.env("DD_AZURE_APP_SERVICES");
        String siteName = ConfigHelper.env("WEBSITE_SITE_NAME");
        if (("true".equalsIgnoreCase(inAas) || "1".equals(inAas)) && siteName != null) {
            return siteName;
        }
        if (this.processInfo.jarFile != null && this.processInfo.jarFile.getName().endsWith(".jar")) {
            return this.processInfo.jarFile.getName().replace(".jar", "");
        }
        return this.processInfo.mainClass;
    }

    public static CapturedEnvironment get() {
        return INSTANCE;
    }

    public static class ProcessInfo {
        public String mainClass;
        public File jarFile;

        public ProcessInfo() {
            String jarName = JavaVirtualMachine.getJarFile();
            this.jarFile = jarName == null ? null : new File(jarName);
            this.mainClass = JavaVirtualMachine.getMainClass();
        }

        ProcessInfo(String mainClass, File jarFile) {
            this.mainClass = mainClass;
            this.jarFile = jarFile;
        }
    }
}

