/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class MethodFilterConfigParser {
    private static final Logger log = LoggerFactory.getLogger(MethodFilterConfigParser.class);

    private static Map<String, Set<String>> logWarn(String message, int start, int end, String configString) {
        String part = configString.substring(start, end).trim();
        log.warn("Invalid trace method config {} in part '{}'. Must match 'package.Class$Name[method1,method2];?' or 'package.Class$Name[*];?'. Config string: '{}'", message, part, configString);
        return Collections.emptyMap();
    }

    private static boolean hasIllegalCharacters(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '*' && c != '[' && c != ']' && c != ',') continue;
            return true;
        }
        return false;
    }

    private static boolean isIllegalClassName(String string) {
        return MethodFilterConfigParser.hasIllegalCharacters(string);
    }

    private static boolean isIllegalMethodName(String string) {
        return !string.equals("*") && MethodFilterConfigParser.hasIllegalCharacters(string);
    }

    @SuppressForbidden
    public static Map<String, Set<String>> parse(String configString) {
        Map<String, Set<String>> classMethodsToTrace;
        if (configString == null || configString.trim().isEmpty()) {
            classMethodsToTrace = Collections.emptyMap();
        } else {
            int next;
            Map<Object, Object> toTrace = new HashMap();
            int start = 0;
            do {
                int end;
                int n = end = (next = configString.indexOf(59, start + 1)) == -1 ? configString.length() : next;
                if (end <= start + 1) continue;
                int methodsStart = configString.indexOf(91, start);
                if (methodsStart == -1) {
                    if (configString.substring(start).trim().isEmpty()) break;
                    toTrace = MethodFilterConfigParser.logWarn("with incomplete definition", start, end, configString);
                    break;
                }
                if (methodsStart >= end) {
                    toTrace = MethodFilterConfigParser.logWarn("with incomplete method definition", start, end, configString);
                    break;
                }
                int methodsEnd = configString.indexOf(93, methodsStart);
                if (methodsEnd == -1 || methodsEnd > end) {
                    toTrace = MethodFilterConfigParser.logWarn("does not contain a ']'", start, end, configString);
                    break;
                }
                if (methodsEnd < end && !configString.substring(methodsEnd + 1, end).trim().isEmpty()) {
                    toTrace = MethodFilterConfigParser.logWarn("with extra characters after ']'", start, end, configString);
                    break;
                }
                String className = configString.substring(start, methodsStart).trim();
                if (className.isEmpty() || MethodFilterConfigParser.isIllegalClassName(className)) {
                    toTrace = MethodFilterConfigParser.logWarn("with illegal class name", start, end, configString);
                    break;
                }
                HashSet<String> methodNames = (HashSet<String>)toTrace.get(className);
                if (null == methodNames) {
                    methodNames = new HashSet<String>();
                    toTrace.put(className, methodNames);
                }
                int methods = 0;
                int emptyMethods = 0;
                boolean hasStar = false;
                int methodStart = methodsStart + 1;
                while (methodStart < methodsEnd) {
                    int nextComma = configString.indexOf(44, methodStart);
                    int methodEnd = nextComma == -1 || nextComma >= methodsEnd ? methodsEnd : nextComma;
                    String method = configString.substring(methodStart, methodEnd).trim();
                    if (MethodFilterConfigParser.isIllegalMethodName(method)) {
                        toTrace = MethodFilterConfigParser.logWarn("with illegal method name", start, end, configString);
                        ++methods;
                        next = -1;
                        break;
                    }
                    if (method.isEmpty()) {
                        if (++emptyMethods > 1) {
                            toTrace = MethodFilterConfigParser.logWarn("with multiple emtpy method names", start, end, configString);
                            ++methods;
                            next = -1;
                            break;
                        }
                    } else {
                        ++methods;
                        if (emptyMethods > 0) {
                            toTrace = MethodFilterConfigParser.logWarn("with method name and emtpy method name", start, end, configString);
                            next = -1;
                            break;
                        }
                        if ((hasStar |= method.indexOf(42) != -1) && methods > 1) {
                            toTrace = MethodFilterConfigParser.logWarn("with both method name and '*'", start, end, configString);
                            next = -1;
                            break;
                        }
                        methodNames.add(method);
                    }
                    methodStart = methodEnd + 1;
                }
                if (methods != 0) continue;
                toTrace = MethodFilterConfigParser.logWarn("with empty method definition", start, end, configString);
                break;
            } while ((start = next + 1) != 0);
            classMethodsToTrace = Collections.unmodifiableMap(toTrace);
        }
        return classMethodsToTrace;
    }
}

