/*
 * Decompiled with CFR 0.152.
 */
package datadog.environment;

import datadog.environment.SystemProperties;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public final class OperatingSystem {
    private static final String OS_NAME_PROPERTY = "os.name";
    private static final String OS_ARCH_PROPERTY = "os.arch";
    private static final Type TYPE = Type.current();
    private static final Architecture ARCHITECTURE = Architecture.current();

    private OperatingSystem() {
    }

    public static boolean isLinux() {
        return TYPE == Type.LINUX;
    }

    public static boolean isWindows() {
        return TYPE == Type.WINDOWS;
    }

    public static boolean isMacOs() {
        return TYPE == Type.MACOS;
    }

    public static Type type() {
        return TYPE;
    }

    public static Architecture architecture() {
        return ARCHITECTURE;
    }

    public static boolean isMusl() {
        if (!OperatingSystem.isLinux()) {
            return false;
        }
        try {
            return OperatingSystem.isMuslJavaExecutable();
        }
        catch (IOException e) {
            try {
                return OperatingSystem.isMuslProcSelfMaps();
            }
            catch (IOException ignore) {
                return false;
            }
        }
    }

    private static boolean isMuslProcSelfMaps() throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader("/proc/self/maps"));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.contains("-musl-")) {
                    boolean bl = true;
                    return bl;
                }
                if (!line.contains("/libc.")) continue;
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }

    private static boolean isMuslJavaExecutable() throws IOException {
        byte[] magic = new byte[]{127, 69, 76, 70};
        byte[] prefix = new byte[]{47, 108, 100, 45};
        byte[] musl = new byte[]{109, 117, 115, 108};
        Path binary = Paths.get(SystemProperties.getOrDefault("java.home", ""), "bin", "java");
        byte[] buffer = new byte[4096];
        try (InputStream is = Files.newInputStream(binary, new OpenOption[0]);){
            int read = is.read(buffer, 0, 4);
            if (read != 4 || !OperatingSystem.containsArray(buffer, 0, magic)) {
                throw new IOException(Arrays.toString(buffer));
            }
            read = is.read(buffer);
            if (read <= 0) {
                throw new IOException();
            }
            int prefixPos = 0;
            for (int i = 0; i < read; ++i) {
                if (buffer[i] == prefix[prefixPos]) {
                    if (++prefixPos != prefix.length) continue;
                    boolean bl = OperatingSystem.containsArray(buffer, i + 1, musl);
                    return bl;
                }
                prefixPos = 0;
            }
        }
        return false;
    }

    private static boolean containsArray(byte[] container, int offset, byte[] contained) {
        for (int i = 0; i < contained.length; ++i) {
            int leftPos = offset + i;
            if (leftPos >= container.length) {
                return false;
            }
            if (container[leftPos] == contained[i]) continue;
            return false;
        }
        return true;
    }

    public static enum Type {
        WINDOWS("Windows"),
        MACOS("MacOS"),
        LINUX("Linux"),
        UNKNOWN("unknown");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        static Type current() {
            String property = SystemProperties.getOrDefault(OperatingSystem.OS_NAME_PROPERTY, "").toLowerCase(Locale.ROOT);
            if (property.contains("linux")) {
                return LINUX;
            }
            if (property.contains("win")) {
                return WINDOWS;
            }
            if (property.contains("mac")) {
                return MACOS;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Architecture {
        X64("x86_64", "amd64", "k8"),
        X86("x86", "i386", "i486", "i586", "i686"),
        ARM("arm", "aarch32"),
        ARM64("arm64", "aarch64"),
        UNKNOWN(new String[0]);

        private final Set<String> identifiers;

        private Architecture(String ... identifiers) {
            this.identifiers = new HashSet<String>(Arrays.asList(identifiers));
        }

        static Architecture of(String identifier) {
            for (Architecture architecture : Architecture.values()) {
                if (!architecture.identifiers.contains(identifier)) continue;
                return architecture;
            }
            return UNKNOWN;
        }

        static Architecture current() {
            String property = SystemProperties.getOrDefault(OperatingSystem.OS_ARCH_PROPERTY, "").toLowerCase(Locale.ROOT);
            return Architecture.of(property);
        }
    }
}

