/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.internal;

import datadog.trace.bootstrap.config.provider.ConfigProvider;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InstrumentationConfig {
    private static final InstrumentationConfig INSTANCE = new InstrumentationConfig();
    private static final Pattern DURATION_PATTERN = Pattern.compile("(\\d+)(ms|[DdHhMmSs]?)");
    private static final ConfigProvider delegate = ConfigProvider.getInstance();

    public static InstrumentationConfig get() {
        return INSTANCE;
    }

    public String getString(String name) {
        return delegate.getString(name);
    }

    public String getString(String name, String defaultValue) {
        return delegate.getString(name, defaultValue, new String[0]);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return delegate.getBoolean(name, defaultValue, new String[0]);
    }

    public int getInt(String name, int defaultValue) {
        return delegate.getInteger(name, defaultValue, new String[0]);
    }

    public long getLong(String name, long defaultValue) {
        return delegate.getLong(name, defaultValue, new String[0]);
    }

    public double getDouble(String name, double defaultValue) {
        return delegate.getDouble(name, defaultValue);
    }

    public Duration getDuration(String name, Duration defaultValue) {
        String durationString = delegate.getString(name);
        if (null == durationString) {
            return defaultValue;
        }
        Matcher matcher = DURATION_PATTERN.matcher(durationString);
        if (matcher.matches()) {
            long value = Integer.parseInt(matcher.group(1));
            String unit = matcher.group(2);
            if ("D".equalsIgnoreCase(unit)) {
                return Duration.ofDays(value);
            }
            if ("H".equalsIgnoreCase(unit)) {
                return Duration.ofHours(value);
            }
            if ("M".equalsIgnoreCase(unit)) {
                return Duration.ofMinutes(value);
            }
            if ("S".equalsIgnoreCase(unit)) {
                return Duration.ofSeconds(value);
            }
            return Duration.ofMillis(value);
        }
        throw new IllegalArgumentException("Invalid duration property " + name + "=" + durationString);
    }

    public List<String> getList(String name) {
        return this.getList(name, Collections.emptyList());
    }

    public List<String> getList(String name, List<String> defaultValue) {
        return delegate.getList(name, defaultValue, new String[0]);
    }

    public Set<String> getSet(String name, Set<String> defaultValue) {
        return delegate.getSet(name, defaultValue);
    }

    public Map<String, String> getMap(String name, Map<String, String> defaultValue) {
        Map<String, String> map = delegate.getMergedMap(name, new String[0]);
        if (map.isEmpty()) {
            map = defaultValue;
        }
        return map;
    }
}

