/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jfr.exceptions;

import datadog.trace.api.Config;
import datadog.trace.api.sampling.PerRecordingRateLimiter;
import datadog.trace.bootstrap.instrumentation.jfr.WindowSampler;
import datadog.trace.bootstrap.instrumentation.jfr.exceptions.ExceptionSampleEvent;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

final class ExceptionSampler
extends WindowSampler<ExceptionSampleEvent> {
    private static final Duration SAMPLING_WINDOW = Duration.of(500L, ChronoUnit.MILLIS);

    ExceptionSampler(Config config) {
        this(SAMPLING_WINDOW, ExceptionSampler.getSamplesPerWindow(config), PerRecordingRateLimiter.samplingWindowsPerRecording(config.getProfilingUploadPeriod(), SAMPLING_WINDOW));
    }

    ExceptionSampler(Duration windowDuration, int samplesPerWindow, int lookback) {
        super(windowDuration, samplesPerWindow, lookback, ExceptionSampleEvent.class);
    }

    protected static int getSamplesPerWindow(Config config) {
        return config.getProfilingExceptionSampleLimit() / PerRecordingRateLimiter.samplingWindowsPerRecording(config.getProfilingUploadPeriod(), SAMPLING_WINDOW);
    }
}

