/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.environment;

import datadog.trace.bootstrap.environment.EnvironmentVariables;
import datadog.trace.bootstrap.environment.JavaVirtualMachine;
import datadog.trace.bootstrap.environment.OperatingSystem;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

class JvmOptions {
    static final String JAVA_TOOL_OPTIONS = "JAVA_TOOL_OPTIONS";
    static final String JDK_JAVA_OPTIONS = "JDK_JAVA_OPTIONS";
    final String[] PROCFS_CMDLINE = this.readProcFsCmdLine();
    final List<String> VM_OPTIONS = this.findVmOptions();

    JvmOptions() {
    }

    @SuppressForbidden
    private String[] readProcFsCmdLine() {
        block9: {
            if (OperatingSystem.isLinux()) {
                String[] stringArray;
                block10: {
                    Path cmdlinePath = Paths.get("/proc/self/cmdline", new String[0]);
                    if (!Files.exists(cmdlinePath, new LinkOption[0]) || !Files.isReadable(cmdlinePath)) break block9;
                    BufferedReader in = Files.newBufferedReader(cmdlinePath);
                    try {
                        stringArray = in.readLine().split("\u0000");
                        if (in == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    in.close();
                }
                return stringArray;
            }
        }
        return null;
    }

    @SuppressForbidden
    private List<String> findVmOptions() {
        if (this.PROCFS_CMDLINE != null) {
            return this.findVmOptionsFromProcFs(this.PROCFS_CMDLINE);
        }
        try {
            Object vmManagement;
            Class<?> managementFactoryHelperClass = Class.forName("sun.management.ManagementFactoryHelper");
            Class<?> vmManagementClass = Class.forName("sun.management.VMManagement");
            try {
                vmManagement = managementFactoryHelperClass.getDeclaredMethod("getVMManagement", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                Field field = managementFactoryHelperClass.getDeclaredField("jvm");
                field.setAccessible(true);
                vmManagement = field.get(null);
                field.setAccessible(false);
            }
            return (List)vmManagementClass.getMethod("getVmArguments", new Class[0]).invoke(vmManagement, new Object[0]);
        }
        catch (Throwable managementFactoryHelperClass) {
            try {
                Class<?> VMClass = Class.forName("com.ibm.oti.vm.VM");
                String[] argArray = (String[])VMClass.getMethod("getVMArgs", new Class[0]).invoke(null, new Object[0]);
                return Arrays.asList(argArray);
            }
            catch (Throwable VMClass) {
                try {
                    return ManagementFactory.getRuntimeMXBean().getInputArguments();
                }
                catch (Throwable t) {
                    System.err.println("WARNING: Unable to get VM args using managed beans");
                    return Collections.emptyList();
                }
            }
        }
    }

    List<String> findVmOptionsFromProcFs(String[] procfsCmdline) {
        List<String> javaToolOptions;
        List<String> jdkJavaOptions;
        ArrayList<String> vmOptions = new ArrayList<String>();
        for (int index = 1; index < procfsCmdline.length; ++index) {
            String argument = procfsCmdline[index];
            if (argument.startsWith("@")) {
                vmOptions.addAll(JvmOptions.getArgumentsFromFile(argument));
                continue;
            }
            if ("-cp".equals(argument)) {
                ++index;
                continue;
            }
            if ("-jar".equals(argument) || !argument.startsWith("-")) break;
            vmOptions.add(argument);
        }
        if (!(jdkJavaOptions = JvmOptions.getJdkJavaOptions()).isEmpty()) {
            vmOptions.addAll(0, jdkJavaOptions);
        }
        if (!(javaToolOptions = JvmOptions.getJavaToolOptions()).isEmpty()) {
            vmOptions.addAll(0, javaToolOptions);
        }
        return vmOptions;
    }

    private static List<String> getArgumentsFromFile(String argFile) {
        String filename = argFile.substring(1);
        Path path = Paths.get(filename, new String[0]);
        if (!Files.exists(path, new LinkOption[0]) || !Files.isReadable(path)) {
            return Collections.singletonList(argFile);
        }
        ArrayList<String> args = new ArrayList<String>();
        try {
            for (String line : Files.readAllLines(path)) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                while (tokenizer.hasMoreTokens()) {
                    args.add(tokenizer.nextToken());
                }
            }
            return args;
        }
        catch (IOException e) {
            return Collections.singletonList(argFile);
        }
    }

    private static List<String> getJavaToolOptions() {
        String javaToolOptions = EnvironmentVariables.getOrDefault(JAVA_TOOL_OPTIONS, "");
        return javaToolOptions.isEmpty() ? Collections.emptyList() : JvmOptions.parseOptions(javaToolOptions);
    }

    private static List<String> getJdkJavaOptions() {
        if (!JavaVirtualMachine.isJavaVersionAtLeast(9)) {
            return Collections.emptyList();
        }
        String sdkToolOptions = EnvironmentVariables.getOrDefault(JDK_JAVA_OPTIONS, "");
        return sdkToolOptions.isEmpty() ? Collections.emptyList() : JvmOptions.parseOptions(sdkToolOptions);
    }

    static List<String> parseOptions(String javaToolOptions) {
        ArrayList<String> options = new ArrayList<String>();
        StringBuilder option = new StringBuilder();
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        for (int i = 0; i < javaToolOptions.length(); ++i) {
            char c = javaToolOptions.charAt(i);
            if (inQuotes) {
                if (quoteChar == c) {
                    inQuotes = false;
                    continue;
                }
                option.append(c);
                continue;
            }
            if (c == '\"' || c == '\'') {
                inQuotes = true;
                quoteChar = c;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (option.length() <= 0) continue;
                options.add(option.toString());
                option.setLength(0);
                continue;
            }
            option.append(c);
        }
        if (option.length() > 0) {
            options.add(option.toString());
        }
        return options;
    }
}

