/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.jms;

import datadog.trace.api.Config;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.jms.SessionState;

public final class MessageConsumerState {
    private final SessionState sessionState;
    private final CharSequence brokerResourceName;
    private final String brokerServiceName;
    private final CharSequence consumerBaseResourceName;
    private final CharSequence consumerResourceName;
    private final boolean propagationDisabled;

    public MessageConsumerState(SessionState sessionState, CharSequence brokerResourceName, CharSequence consumerBaseResourceName, CharSequence consumerResourceName, boolean propagationDisabled) {
        String brokerServiceName;
        this.sessionState = sessionState;
        this.brokerResourceName = brokerResourceName;
        this.consumerBaseResourceName = consumerBaseResourceName;
        this.consumerResourceName = consumerResourceName;
        this.propagationDisabled = propagationDisabled;
        this.brokerServiceName = Config.get().isMessageBrokerSplitByDestination() ? ((brokerServiceName = brokerResourceName.toString()).startsWith("Queue ") || brokerServiceName.startsWith("Topic ") ? brokerServiceName.substring(6) : brokerServiceName) : null;
    }

    public SessionState getSessionState() {
        return this.sessionState;
    }

    public CharSequence getBrokerResourceName() {
        return this.brokerResourceName;
    }

    public String getBrokerServiceName() {
        return this.brokerServiceName;
    }

    public CharSequence getConsumerBaseResourceName() {
        return this.consumerBaseResourceName;
    }

    public CharSequence getConsumerResourceName() {
        return this.consumerResourceName;
    }

    public boolean isPropagationDisabled() {
        return this.propagationDisabled;
    }

    public AgentSpan getTimeInQueueSpan(long batchId) {
        return this.sessionState.getTimeInQueueSpan(batchId);
    }

    public void setTimeInQueueSpan(long batchId, AgentSpan span) {
        this.sessionState.setTimeInQueueSpan(batchId, span);
    }

    public void finishTimeInQueueSpan(boolean clear) {
        this.sessionState.finishTimeInQueueSpan(clear);
    }
}

