/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.classmatch;

final class TypeString
implements CharSequence {
    private final String descriptor;
    private final int offset;
    private final int len;
    private final int hash;

    static int computeHash(String descriptor, int start, int end) {
        int h = 0;
        for (int i = start; i < end; ++i) {
            h = 31 * h + descriptor.charAt(i);
        }
        return h;
    }

    TypeString(String descriptor, int start, int end, int hash) {
        this.descriptor = descriptor;
        this.offset = start;
        this.len = end - start;
        this.hash = hash;
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public char charAt(int index) {
        return this.descriptor.charAt(this.offset + index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        throw new UnsupportedOperationException("Partial TypeStrings not allowed");
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o instanceof CharSequence) {
            CharSequence cs = (CharSequence)o;
            if (this.len != cs.length()) {
                return false;
            }
            int i = this.offset;
            for (int j = 0; j < this.len; ++j) {
                if (this.descriptor.charAt(i) != cs.charAt(j)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.descriptor.substring(this.offset, this.offset + this.len);
    }

    static boolean startsWith(CharSequence cs, String prefix) {
        if (cs instanceof TypeString) {
            TypeString ts = (TypeString)cs;
            return ts.descriptor.startsWith(prefix, ts.offset);
        }
        return cs.toString().startsWith(prefix);
    }

    static boolean endsWith(CharSequence cs, String suffix) {
        if (cs instanceof TypeString) {
            TypeString ts = (TypeString)cs;
            return ts.descriptor.startsWith(suffix, ts.offset + ts.len - suffix.length());
        }
        return cs.toString().endsWith(suffix);
    }
}

