/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util;

import java.io.IOException;
import java.io.InputStream;

public class SizeCheckedInputStream
extends InputStream {
    private final InputStream in;
    private final long maxSize;
    private long currentSize;

    public SizeCheckedInputStream(InputStream in, long maxSize) {
        this.in = in;
        this.maxSize = maxSize;
    }

    @Override
    public int read() throws IOException {
        this.checkSize(1L);
        int v = this.in.read();
        if (v != -1) {
            this.updateCurrentSize(1);
        }
        return v;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.maxSize == this.currentSize) {
            throw new IOException("Reached maximum bytes for this stream: " + this.maxSize);
        }
        long safeLen = Math.min((long)len, this.maxSize - this.currentSize);
        this.checkSize(safeLen);
        return this.updateCurrentSize(this.in.read(b, off, (int)safeLen));
    }

    private int updateCurrentSize(int delta) {
        if (delta > 0) {
            this.currentSize += (long)delta;
        }
        return delta;
    }

    private void checkSize(long neededBytes) throws IOException {
        if (this.currentSize + neededBytes > this.maxSize) {
            throw new IOException("Reached maximum bytes for this stream: " + this.maxSize);
        }
    }
}

