/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.instrumentation.api.semconv.http;

import datadog.trace.bootstrap.otel.api.incubator.metrics.ExtendedDoubleHistogramBuilder;
import datadog.trace.bootstrap.otel.api.metrics.DoubleHistogramBuilder;
import datadog.trace.bootstrap.otel.semconv.ErrorAttributes;
import datadog.trace.bootstrap.otel.semconv.HttpAttributes;
import datadog.trace.bootstrap.otel.semconv.NetworkAttributes;
import datadog.trace.bootstrap.otel.semconv.ServerAttributes;
import datadog.trace.bootstrap.otel.semconv.UrlAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class HttpMetricsAdvice {
    static final List<Double> DURATION_SECONDS_BUCKETS = Collections.unmodifiableList(Arrays.asList(0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0));

    static void applyClientDurationAdvice(DoubleHistogramBuilder builder) {
        if (!(builder instanceof ExtendedDoubleHistogramBuilder)) {
            return;
        }
        ((ExtendedDoubleHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(HttpAttributes.HTTP_REQUEST_METHOD, HttpAttributes.HTTP_RESPONSE_STATUS_CODE, ErrorAttributes.ERROR_TYPE, NetworkAttributes.NETWORK_PROTOCOL_NAME, NetworkAttributes.NETWORK_PROTOCOL_VERSION, ServerAttributes.SERVER_ADDRESS, ServerAttributes.SERVER_PORT));
    }

    static void applyServerDurationAdvice(DoubleHistogramBuilder builder) {
        if (!(builder instanceof ExtendedDoubleHistogramBuilder)) {
            return;
        }
        ((ExtendedDoubleHistogramBuilder)builder).setAttributesAdvice(Arrays.asList(HttpAttributes.HTTP_ROUTE, HttpAttributes.HTTP_REQUEST_METHOD, HttpAttributes.HTTP_RESPONSE_STATUS_CODE, ErrorAttributes.ERROR_TYPE, NetworkAttributes.NETWORK_PROTOCOL_NAME, NetworkAttributes.NETWORK_PROTOCOL_VERSION, UrlAttributes.URL_SCHEME));
    }

    private HttpMetricsAdvice() {
    }
}

