/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.config.provider.civisibility;

import datadog.environment.EnvironmentVariables;
import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.util.ConfigStrings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class CiEnvironmentVariables {
    private static final Logger logger = LoggerFactory.getLogger(CiEnvironmentVariables.class);
    static final String CIVISIBILITY_REMOTE_ENV_VARS_PROVIDER_URL = "dd.civisibility.remote.env.vars.provider.url";
    static final String CIVISIBILITY_REMOTE_ENV_VARS_PROVIDER_KEY = "dd.civisibility.remote.env.vars.provider.key";
    static final String DD_ENV_VARS_PROVIDER_KEY_HEADER = "DD-Env-Vars-Provider-Key";
    static final String ACCEPT_HEADER = "Accept";
    private static final int CONNECT_TIMEOUT_MILLIS = 5000;
    private static final int READ_TIMEOUT_MILLIS = 10000;
    private static final Map<String, String> REMOTE_ENVIRONMENT;

    private static String getConfigValue(String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        return EnvironmentVariables.get(ConfigStrings.toEnvVar(propertyName));
    }

    static Map<String, String> getRemoteEnvironmentWithRetries(String url, String key, RetryPolicy retryPolicy, Map<String, String> fallbackValue) {
        return CiEnvironmentVariables.doWithBackoffRetries(() -> CiEnvironmentVariables.getRemoteEnvironment(url, key), retryPolicy, fallbackValue);
    }

    private static <T> T doWithBackoffRetries(Callable<T> action, RetryPolicy retryPolicy, T fallbackValue) {
        long delayMillis = retryPolicy.delayMillis;
        for (int i = 0; i < retryPolicy.maxAttempts; ++i) {
            if (Thread.currentThread().isInterrupted()) {
                logger.warn("Interrupted while trying to read remote environment");
                return fallbackValue;
            }
            try {
                return action.call();
            }
            catch (Exception e) {
                logger.warn("Error while trying to read remote environment", e);
                CiEnvironmentVariables.sleep(delayMillis);
                delayMillis = Math.round((double)delayMillis * retryPolicy.backoffFactor);
                continue;
            }
        }
        return fallbackValue;
    }

    private static void sleep(long delayMillis) {
        try {
            Thread.sleep(delayMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static Map<String, String> getRemoteEnvironment(String url, String key) throws Exception {
        HttpURLConnection conn = null;
        try {
            URL target = new URL(url);
            conn = (HttpURLConnection)target.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty(DD_ENV_VARS_PROVIDER_KEY_HEADER, key);
            conn.setRequestProperty(ACCEPT_HEADER, "text/plain");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(10000);
            int code = conn.getResponseCode();
            if (code >= 200 && code < 300) {
                Properties properties = new Properties();
                try (InputStreamReader r = new InputStreamReader(conn.getInputStream(), StandardCharsets.ISO_8859_1);){
                    properties.load(r);
                }
                Map<String, String> map = CiEnvironmentVariables.asMap(properties);
                return map;
            }
            BufferedReader r = new BufferedReader(new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                try {
                    String body = r.lines().collect(Collectors.joining("\n"));
                    throw new IOException(String.format("Remote environment request failed (HTTP %d) %s", code, body));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (r != null) {
                    if (throwable != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        r.close();
                    }
                }
                throw throwable3;
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private static Map<String, String> asMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : properties.stringPropertyNames()) {
            map.put(name, properties.getProperty(name));
        }
        return map;
    }

    @Nullable
    public static String get(String name) {
        if (REMOTE_ENVIRONMENT == null) {
            return null;
        }
        return REMOTE_ENVIRONMENT.get(name);
    }

    @Nullable
    public static Map<String, String> getAll() {
        return REMOTE_ENVIRONMENT != null ? Collections.unmodifiableMap(REMOTE_ENVIRONMENT) : null;
    }

    static {
        String url = CiEnvironmentVariables.getConfigValue(CIVISIBILITY_REMOTE_ENV_VARS_PROVIDER_URL);
        String key = CiEnvironmentVariables.getConfigValue(CIVISIBILITY_REMOTE_ENV_VARS_PROVIDER_KEY);
        REMOTE_ENVIRONMENT = url != null && key != null ? CiEnvironmentVariables.getRemoteEnvironmentWithRetries(url, key, new RetryPolicy(500L, 5, 2.0), null) : null;
    }

    static final class RetryPolicy {
        long delayMillis;
        int maxAttempts;
        double backoffFactor;

        public RetryPolicy(long delayMillis, int maxAttempts, double backoffFactor) {
            this.delayMillis = delayMillis;
            this.maxAttempts = maxAttempts;
            this.backoffFactor = backoffFactor;
        }
    }
}

