/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.trace.bootstrap.environment.SystemProperties;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class AgentJar {
    private static final Class<?> thisClass = AgentJar.class;
    private static Class<?> agentClass;

    @SuppressForbidden
    public static void main(String[] args) {
        if (args.length == 0) {
            AgentJar.printAgentVersion();
        } else {
            try {
                agentClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.Agent");
                switch (args[0]) {
                    case "sampleTrace": {
                        AgentJar.sendSampleTrace(args);
                        break;
                    }
                    case "uploadCrash": {
                        AgentJar.uploadCrash(args);
                        break;
                    }
                    case "sendOomeEvent": {
                        AgentJar.sendOomeEvent(args);
                        break;
                    }
                    case "scanDependencies": {
                        AgentJar.scanDependencies(args);
                        break;
                    }
                    case "checkProfilerEnv": {
                        AgentJar.checkProfilerEnv(args);
                        break;
                    }
                    case "--list-integrations": 
                    case "-li": {
                        AgentJar.printIntegrationNames();
                        break;
                    }
                    case "--help": 
                    case "-h": {
                        AgentJar.printUsage();
                        break;
                    }
                    case "--version": 
                    case "-v": {
                        AgentJar.printAgentVersion();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(args[0]);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                System.out.println("unknown option: " + e.getMessage());
                AgentJar.printUsage();
            }
            catch (Throwable e) {
                System.out.println("Failed to process agent option");
                e.printStackTrace();
            }
        }
    }

    @SuppressForbidden
    private static void printUsage() {
        System.out.println("usage:");
        System.out.println("  sampleTrace [-c count] [-i interval]");
        System.out.println("  uploadCrash -c configFile crashFile");
        System.out.println("  scanDependencies <path> ...");
        System.out.println("  checkProfilerEnv [temp]");
        System.out.println("  [-li | --list-integrations]");
        System.out.println("  [-h  | --help]");
        System.out.println("  [-v  | --version]");
    }

    private static void sendSampleTrace(String[] args) throws Exception {
        int count = -1;
        double interval = 1.0;
        if (args.length % 2 == 0) {
            throw new IllegalArgumentException("missing value");
        }
        block8: for (int i = 1; i < args.length; i += 2) {
            switch (args[i]) {
                case "-c": {
                    count = Integer.parseInt(args[i + 1]);
                    continue block8;
                }
                case "-i": {
                    interval = Double.parseDouble(args[i + 1]);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException(args[i]);
                }
            }
        }
        AgentJar.installAgentCLI().getMethod("sendSampleTraces", Integer.TYPE, Double.TYPE).invoke(null, count, interval);
    }

    private static void uploadCrash(String[] args) throws Exception {
        if (args.length < 2 || "-c".equals(args[1]) && args.length < 4) {
            throw new IllegalArgumentException("Arguments mismatch. At least one crash report should be provided");
        }
        int crashFilePos = 1;
        String configFile = null;
        if ("-c".equals(args[1])) {
            configFile = args[2];
            crashFilePos = 3;
        }
        AgentJar.installAgentCLI().getMethod("uploadCrash", String.class, String.class).invoke(null, configFile, args[crashFilePos]);
    }

    private static void sendOomeEvent(String[] args) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("missing taglist");
        }
        AgentJar.installAgentCLI().getMethod("sendOomeEvent", String.class).invoke(null, args[1]);
    }

    private static void scanDependencies(String[] args) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("missing path");
        }
        AgentJar.installAgentCLI().getMethod("scanDependencies", String[].class).invoke(null, new Object[]{Arrays.copyOfRange(args, 1, args.length)});
    }

    private static void printIntegrationNames() throws Exception {
        AgentJar.installAgentCLI().getMethod("printIntegrationNames", new Class[0]).invoke(null, new Object[0]);
    }

    private static Class<?> installAgentCLI() throws Exception {
        return (Class)agentClass.getMethod("installAgentCLI", new Class[0]).invoke(null, new Object[0]);
    }

    @SuppressForbidden
    private static void printAgentVersion() {
        try {
            System.out.println(AgentJar.getAgentVersion());
        }
        catch (Exception e) {
            System.out.println("Failed to parse agent version");
            e.printStackTrace();
        }
    }

    public static String tryGetAgentVersion() {
        return AgentJar.getAgentVersionOrDefault(null);
    }

    public static String getAgentVersionOrDefault(String defaultValue) {
        try {
            return AgentJar.getAgentVersion();
        }
        catch (IOException e) {
            return defaultValue;
        }
    }

    public static String getAgentVersion() throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(thisClass.getResourceAsStream("/dd-java-agent.version"), StandardCharsets.UTF_8));){
            int c = reader.read();
            while (c != -1) {
                sb.append((char)c);
                c = reader.read();
            }
        }
        return sb.toString().trim();
    }

    private static void checkProfilerEnv(String[] args) throws Exception {
        String tmpDir = args.length == 2 ? args[1] : SystemProperties.get("java.io.tmpdir");
        AgentJar.installAgentCLI().getMethod("checkProfilerEnv", String.class).invoke(null, tmpDir);
    }
}

