/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.ConfigDefaults;
import datadog.trace.api.MethodFilterConfigParser;
import datadog.trace.api.Platform;
import datadog.trace.api.ProductActivation;
import datadog.trace.api.ResolverCacheConfig;
import datadog.trace.api.profiling.ProfilingEnablement;
import datadog.trace.api.telemetry.OtelEnvMetricCollectorImpl;
import datadog.trace.api.telemetry.OtelEnvMetricCollectorProvider;
import datadog.trace.bootstrap.config.provider.ConfigProvider;
import datadog.trace.util.CollectionUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InstrumenterConfig {
    private final ConfigProvider configProvider;
    private final boolean triageEnabled;
    private final boolean integrationsEnabled;
    private final boolean codeOriginEnabled;
    private final boolean traceEnabled;
    private final boolean traceOtelEnabled;
    private final ProfilingEnablement profilingEnabled;
    private final boolean ciVisibilityEnabled;
    private final ProductActivation appSecActivation;
    private final ProductActivation iastActivation;
    private final boolean iastFullyDisabled;
    private final boolean usmEnabled;
    private final boolean telemetryEnabled;
    private final boolean llmObsEnabled;
    private final String traceExtensionsPath;
    private final boolean traceExecutorsAll;
    private final List<String> traceExecutors;
    private final Set<String> traceThreadPoolExecutorsExclude;
    private final String jdbcPreparedStatementClassName;
    private final String jdbcConnectionClassName;
    private final boolean jdbcPoolWaitingEnabled;
    private final String httpURLConnectionClassName;
    private final String axisTransportClassName;
    private final boolean websocketTracingEnabled;
    private final boolean pekkoSchedulerEnabled;
    private final String akkaForkJoinTaskName;
    private final String akkaForkJoinExecutorTaskName;
    private final String akkaForkJoinPoolName;
    private final boolean directAllocationProfilingEnabled;
    private final String instrumentationConfigId;
    private final List<String> excludedClasses;
    private final String excludedClassesFile;
    private final Set<String> excludedClassLoaders;
    private final List<String> excludedCodeSources;
    private final Set<String> deferredClassLoaders;
    private final String deferIntegrationsUntil;
    private final ResolverCacheConfig resolverCacheConfig;
    private final String resolverCacheDir;
    private final boolean resolverNamesAreUnique;
    private final boolean resolverSimpleMethodGraph;
    private final boolean resolverUseLoadClass;
    private final Boolean resolverUseUrlCaches;
    private final int resolverResetInterval;
    private final boolean runtimeContextFieldInjection;
    private final boolean serialVersionUIDFieldInjection;
    private final String traceAnnotations;
    private final boolean traceAnnotationAsync;
    private final Map<String, Set<String>> traceMethods;
    private final Map<String, Set<String>> measureMethods;
    private final boolean internalExitOnFailure;
    private final Collection<String> additionalJaxRsAnnotations;
    private final boolean rumEnabled;
    @SuppressFBWarnings(value={"SI_INSTANCE_BEFORE_FINALS_ASSIGNED"})
    private static final InstrumenterConfig INSTANCE;

    private InstrumenterConfig() {
        this(ConfigProvider.createDefault());
    }

    InstrumenterConfig(ConfigProvider configProvider) {
        this.configProvider = configProvider;
        if (null != configProvider.getString("triage.report.trigger")) {
            this.triageEnabled = true;
        } else {
            boolean debugEnabled = configProvider.getBoolean("trace.debug", false, new String[0]);
            this.triageEnabled = configProvider.getBoolean("trace.triage", debugEnabled, new String[0]);
        }
        this.integrationsEnabled = configProvider.getBoolean("integrations.enabled", true, new String[0]);
        this.codeOriginEnabled = configProvider.getBoolean("code.origin.for.spans.enabled", false, new String[0]);
        this.traceEnabled = configProvider.getBoolean("trace.enabled", true, new String[0]);
        this.traceOtelEnabled = configProvider.getBoolean("trace.otel.enabled", false, new String[0]);
        this.profilingEnabled = ProfilingEnablement.of(configProvider.getString("profiling.enabled", String.valueOf(false), new String[0]));
        this.rumEnabled = configProvider.getBoolean("rum.enabled", false, new String[0]);
        if (!Platform.isNativeImageBuilder()) {
            this.ciVisibilityEnabled = configProvider.getBoolean("civisibility.enabled", false, new String[0]);
            this.appSecActivation = ProductActivation.fromString(configProvider.getStringNotEmpty("appsec.enabled", "inactive", new String[0]));
            this.iastActivation = ProductActivation.fromString(configProvider.getStringNotEmpty("iast.enabled", "false", new String[0]));
            Boolean iastEnabled = configProvider.getBoolean("iast.enabled");
            this.iastFullyDisabled = iastEnabled != null && iastEnabled == false;
            this.usmEnabled = configProvider.getBoolean("usm.enabled", false, new String[0]);
            this.telemetryEnabled = configProvider.getBoolean("instrumentation.telemetry.enabled", true, new String[0]);
            this.llmObsEnabled = configProvider.getBoolean("llmobs.enabled", false, new String[0]);
        } else {
            this.ciVisibilityEnabled = false;
            this.appSecActivation = ProductActivation.FULLY_DISABLED;
            this.iastActivation = ProductActivation.FULLY_DISABLED;
            this.iastFullyDisabled = true;
            this.telemetryEnabled = false;
            this.usmEnabled = false;
            this.llmObsEnabled = false;
        }
        this.traceExtensionsPath = configProvider.getString("trace.extensions.path");
        this.traceExecutorsAll = configProvider.getBoolean("trace.executors.all", false, new String[0]);
        this.traceExecutors = CollectionUtils.tryMakeImmutableList(configProvider.getList("trace.executors"));
        this.traceThreadPoolExecutorsExclude = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.thread-pool-executors.exclude"));
        this.jdbcPreparedStatementClassName = configProvider.getString("trace.jdbc.prepared.statement.class.name", "", new String[0]);
        this.jdbcConnectionClassName = configProvider.getString("trace.jdbc.connection.class.name", "", new String[0]);
        this.jdbcPoolWaitingEnabled = configProvider.getBoolean("trace.experimental.jdbc.pool.waiting.enabled", false, new String[0]);
        this.httpURLConnectionClassName = configProvider.getString("trace.http.url.connection.class.name", "", new String[0]);
        this.axisTransportClassName = configProvider.getString("trace.axis.transport.class.name", "", new String[0]);
        this.akkaForkJoinTaskName = configProvider.getString("trace.akka.fork.join.task.name", "", new String[0]);
        this.akkaForkJoinExecutorTaskName = configProvider.getString("trace.akka.fork.join.executor.task.name", "", new String[0]);
        this.akkaForkJoinPoolName = configProvider.getString("trace.akka.fork.join.pool.name", "", new String[0]);
        this.directAllocationProfilingEnabled = configProvider.getBoolean("profiling.directallocation.enabled", false, new String[0]);
        this.excludedClasses = CollectionUtils.tryMakeImmutableList(configProvider.getList("trace.classes.exclude"));
        this.excludedClassesFile = configProvider.getString("trace.classes.exclude.file");
        this.excludedClassLoaders = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.classloaders.exclude"));
        this.excludedCodeSources = CollectionUtils.tryMakeImmutableList(configProvider.getList("trace.codesources.exclude"));
        this.deferredClassLoaders = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.classloaders.defer"));
        this.deferIntegrationsUntil = configProvider.getString("experimental.defer.integrations.until");
        this.resolverCacheConfig = configProvider.getEnum("resolver.cache.config", ResolverCacheConfig.class, ResolverCacheConfig.MEMOS);
        this.resolverCacheDir = configProvider.getString("resolver.cache.dir");
        this.resolverNamesAreUnique = configProvider.getBoolean("resolver.names.are.unique", false, new String[0]);
        this.resolverSimpleMethodGraph = configProvider.getBoolean("resolver.simple.method.graph", !Platform.isNativeImageBuilder(), new String[0]);
        this.resolverUseLoadClass = configProvider.getBoolean("resolver.use.loadclass", true, new String[0]);
        this.resolverUseUrlCaches = configProvider.getBoolean("resolver.use.url.caches");
        this.resolverResetInterval = Platform.isNativeImageBuilder() ? 0 : configProvider.getInteger("resolver.reset.interval", 300, new String[0]);
        this.runtimeContextFieldInjection = configProvider.getBoolean("trace.runtime.context.field.injection", true, new String[0]);
        this.serialVersionUIDFieldInjection = configProvider.getBoolean("trace.serialversionuid.field.injection", true, new String[0]);
        this.instrumentationConfigId = configProvider.getString("instrumentation_config_id", "", new String[0]);
        this.traceAnnotations = configProvider.getString("trace.annotations", ConfigDefaults.DEFAULT_TRACE_ANNOTATIONS, new String[0]);
        this.traceAnnotationAsync = configProvider.getBoolean("trace.annotation.async", false, new String[0]);
        this.traceMethods = MethodFilterConfigParser.parse(configProvider.getString("trace.methods", ConfigDefaults.DEFAULT_TRACE_METHODS, new String[0]));
        this.measureMethods = MethodFilterConfigParser.parse(configProvider.getString("measure.methods", "", new String[0]));
        this.internalExitOnFailure = configProvider.getBoolean("trace.internal.exit.on.failure", false, new String[0]);
        this.additionalJaxRsAnnotations = CollectionUtils.tryMakeImmutableSet(configProvider.getList("trace.jax-rs.additional.annotations"));
        this.websocketTracingEnabled = configProvider.getBoolean("trace.websocket.messages.enabled", false, new String[0]);
        this.pekkoSchedulerEnabled = configProvider.getBoolean("trace.pekko.scheduler.enabled", false, new String[0]);
    }

    public boolean isCodeOriginEnabled() {
        return this.codeOriginEnabled;
    }

    public boolean isTriageEnabled() {
        return this.triageEnabled;
    }

    public boolean isIntegrationsEnabled() {
        return this.integrationsEnabled;
    }

    public boolean isIntegrationEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        boolean anyEnabled = defaultEnabled;
        for (String name : integrationNames) {
            String primaryKey = "trace." + name + ".enabled";
            String[] aliases = new String[]{"trace.integration." + name + ".enabled", "integration." + name + ".enabled"};
            boolean configEnabled = this.configProvider.getBoolean(primaryKey, defaultEnabled, aliases);
            if (defaultEnabled) {
                anyEnabled &= configEnabled;
                continue;
            }
            anyEnabled |= configEnabled;
        }
        return anyEnabled;
    }

    public boolean isIntegrationShortcutMatchingEnabled(Iterable<String> integrationNames, boolean defaultEnabled) {
        return this.configProvider.isEnabled(integrationNames, "integration.", ".matching.shortcut.enabled", defaultEnabled);
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public boolean isTraceOtelEnabled() {
        return this.traceOtelEnabled;
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled.isActive();
    }

    public boolean isCiVisibilityEnabled() {
        return this.ciVisibilityEnabled;
    }

    public ProductActivation getAppSecActivation() {
        return this.appSecActivation;
    }

    public ProductActivation getIastActivation() {
        return this.iastActivation;
    }

    public boolean isIastFullyDisabled() {
        return this.iastFullyDisabled;
    }

    public boolean isLlmObsEnabled() {
        return this.llmObsEnabled;
    }

    public boolean isUsmEnabled() {
        return this.usmEnabled;
    }

    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    public String getTraceExtensionsPath() {
        return this.traceExtensionsPath;
    }

    public boolean isTraceExecutorsAll() {
        return this.traceExecutorsAll;
    }

    public List<String> getTraceExecutors() {
        return this.traceExecutors;
    }

    public Set<String> getTraceThreadPoolExecutorsExclude() {
        return this.traceThreadPoolExecutorsExclude;
    }

    public String getJdbcPreparedStatementClassName() {
        return this.jdbcPreparedStatementClassName;
    }

    public String getJdbcConnectionClassName() {
        return this.jdbcConnectionClassName;
    }

    public boolean isJdbcPoolWaitingEnabled() {
        return this.jdbcPoolWaitingEnabled;
    }

    public String getHttpURLConnectionClassName() {
        return this.httpURLConnectionClassName;
    }

    public String getAxisTransportClassName() {
        return this.axisTransportClassName;
    }

    public String getAkkaForkJoinTaskName() {
        return this.akkaForkJoinTaskName;
    }

    public String getAkkaForkJoinExecutorTaskName() {
        return this.akkaForkJoinExecutorTaskName;
    }

    public String getAkkaForkJoinPoolName() {
        return this.akkaForkJoinPoolName;
    }

    public boolean isDirectAllocationProfilingEnabled() {
        return this.directAllocationProfilingEnabled;
    }

    public List<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public String getExcludedClassesFile() {
        return this.excludedClassesFile;
    }

    public Set<String> getExcludedClassLoaders() {
        return this.excludedClassLoaders;
    }

    public List<String> getExcludedCodeSources() {
        return this.excludedCodeSources;
    }

    public Set<String> getDeferredClassLoaders() {
        return this.deferredClassLoaders;
    }

    public String deferIntegrationsUntil() {
        return this.deferIntegrationsUntil;
    }

    public int getResolverNoMatchesSize() {
        return this.resolverCacheConfig.noMatchesSize();
    }

    public int getResolverVisibilitySize() {
        return this.resolverCacheConfig.visibilitySize();
    }

    public boolean isResolverMemoizingEnabled() {
        return this.resolverCacheConfig.memoPoolSize() > 0;
    }

    public int getResolverMemoPoolSize() {
        return this.resolverCacheConfig.memoPoolSize();
    }

    public boolean isResolverOutliningEnabled() {
        return this.resolverCacheConfig.outlinePoolSize() > 0;
    }

    public int getResolverOutlinePoolSize() {
        return this.resolverCacheConfig.outlinePoolSize();
    }

    public int getResolverTypePoolSize() {
        return this.resolverCacheConfig.typePoolSize();
    }

    public String getResolverCacheDir() {
        return this.resolverCacheDir;
    }

    public String getInstrumentationConfigId() {
        return this.instrumentationConfigId;
    }

    public boolean isResolverNamesAreUnique() {
        return this.resolverNamesAreUnique;
    }

    public boolean isResolverSimpleMethodGraph() {
        return this.resolverSimpleMethodGraph;
    }

    public boolean isResolverUseLoadClass() {
        return this.resolverUseLoadClass;
    }

    public Boolean isResolverUseUrlCaches() {
        return this.resolverUseUrlCaches;
    }

    public int getResolverResetInterval() {
        return this.resolverResetInterval;
    }

    public boolean isRuntimeContextFieldInjection() {
        return this.runtimeContextFieldInjection;
    }

    public boolean isSerialVersionUIDFieldInjection() {
        return this.serialVersionUIDFieldInjection;
    }

    public String getTraceAnnotations() {
        return this.traceAnnotations;
    }

    public Collection<String> getAdditionalJaxRsAnnotations() {
        return this.additionalJaxRsAnnotations;
    }

    public boolean isWebsocketTracingEnabled() {
        return this.websocketTracingEnabled;
    }

    public boolean isPekkoSchedulerEnabled() {
        return this.pekkoSchedulerEnabled;
    }

    public boolean isTraceAnnotationAsync() {
        return this.traceAnnotationAsync;
    }

    public Map<String, Set<String>> getTraceMethods() {
        return this.traceMethods;
    }

    public boolean isMethodMeasured(Method method) {
        if (this.measureMethods.isEmpty()) {
            return false;
        }
        String clazz = method.getDeclaringClass().getName();
        Set<String> methods = this.measureMethods.get(clazz);
        return methods != null && (methods.contains(method.getName()) || methods.contains("*"));
    }

    public boolean isInternalExitOnFailure() {
        return this.internalExitOnFailure;
    }

    public boolean isLegacyInstrumentationEnabled(boolean defaultEnabled, String ... integrationNames) {
        return this.configProvider.isEnabled(Arrays.asList(integrationNames), "", ".legacy.tracing.enabled", defaultEnabled);
    }

    public boolean isRumEnabled() {
        return this.rumEnabled;
    }

    public static InstrumenterConfig get() {
        return INSTANCE;
    }

    public String toString() {
        return "InstrumenterConfig{integrationsEnabled=" + this.integrationsEnabled + ", traceEnabled=" + this.traceEnabled + ", traceOtelEnabled=" + this.traceOtelEnabled + ", profilingEnabled=" + (Object)((Object)this.profilingEnabled) + ", ciVisibilityEnabled=" + this.ciVisibilityEnabled + ", appSecActivation=" + (Object)((Object)this.appSecActivation) + ", iastActivation=" + (Object)((Object)this.iastActivation) + ", usmEnabled=" + this.usmEnabled + ", telemetryEnabled=" + this.telemetryEnabled + ", traceExtensionsPath=" + this.traceExtensionsPath + ", traceExecutorsAll=" + this.traceExecutorsAll + ", traceExecutors=" + this.traceExecutors + ", jdbcPreparedStatementClassName='" + this.jdbcPreparedStatementClassName + '\'' + ", jdbcConnectionClassName='" + this.jdbcConnectionClassName + '\'' + ", jdbcPoolWaitingEnabled=" + this.jdbcPoolWaitingEnabled + ", httpURLConnectionClassName='" + this.httpURLConnectionClassName + '\'' + ", axisTransportClassName='" + this.axisTransportClassName + '\'' + ", excludedClasses=" + this.excludedClasses + ", excludedClassesFile=" + this.excludedClassesFile + ", excludedClassLoaders=" + this.excludedClassLoaders + ", excludedCodeSources=" + this.excludedCodeSources + ", deferredClassLoaders=" + this.deferredClassLoaders + ", deferIntegrationsUntil=" + this.deferIntegrationsUntil + ", resolverCacheConfig=" + (Object)((Object)this.resolverCacheConfig) + ", resolverCacheDir=" + this.resolverCacheDir + ", resolverNamesAreUnique=" + this.resolverNamesAreUnique + ", resolverSimpleMethodGraph=" + this.resolverSimpleMethodGraph + ", resolverUseLoadClass=" + this.resolverUseLoadClass + ", resolverUseUrlCaches=" + this.resolverUseUrlCaches + ", resolverResetInterval=" + this.resolverResetInterval + ", runtimeContextFieldInjection=" + this.runtimeContextFieldInjection + ", serialVersionUIDFieldInjection=" + this.serialVersionUIDFieldInjection + ", codeOriginEnabled=" + this.codeOriginEnabled + ", traceAnnotations='" + this.traceAnnotations + '\'' + ", traceAnnotationAsync=" + this.traceAnnotationAsync + ", traceMethods='" + this.traceMethods + '\'' + ", measureMethods= '" + this.measureMethods + '\'' + ", internalExitOnFailure=" + this.internalExitOnFailure + ", additionalJaxRsAnnotations=" + this.additionalJaxRsAnnotations + ", websocketTracingEnabled=" + this.websocketTracingEnabled + ", pekkoSchedulerEnabled=" + this.pekkoSchedulerEnabled + ", rumEnabled=" + this.rumEnabled + '}';
    }

    static {
        OtelEnvMetricCollectorProvider.register(OtelEnvMetricCollectorImpl.getInstance());
        INSTANCE = new InstrumenterConfig(Platform.isNativeImageBuilder() ? ConfigProvider.withoutCollector() : ConfigProvider.getInstance());
    }
}

