/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.ConfigCollector;
import datadog.trace.api.TraceConfig;
import datadog.trace.api.sampling.SamplingRule;
import datadog.trace.util.CollectionUtils;
import datadog.trace.util.ConfigStrings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class DynamicConfig<S extends Snapshot> {
    static final Logger rootLogger = LoggerFactory.getLogger("ROOT");
    static final Function<Map.Entry<String, String>, String> KEY = DynamicConfig::key;
    static final Function<Map.Entry<String, String>, String> VALUE = DynamicConfig::value;
    static final Function<Map.Entry<String, String>, String> LOWER_KEY = DynamicConfig::lowerKey;
    static final Function<Map.Entry<String, String>, String> REQUEST_TAG = DynamicConfig::requestTag;
    static final Function<Map.Entry<String, String>, String> RESPONSE_TAG = DynamicConfig::responseTag;
    BiFunction<Builder, S, S> snapshotFactory;
    S initialSnapshot;
    volatile S currentSnapshot;

    private DynamicConfig(BiFunction<Builder, S, S> snapshotFactory) {
        this.snapshotFactory = snapshotFactory;
    }

    public static Builder create() {
        return new DynamicConfig<Snapshot>(Snapshot::new).new Builder();
    }

    public static <S extends Snapshot> Builder create(BiFunction<Builder, S, S> snapshotFactory) {
        return new DynamicConfig<S>(snapshotFactory).new Builder();
    }

    public S captureTraceConfig() {
        return this.currentSnapshot;
    }

    public Builder initial() {
        return new Builder((Snapshot)this.initialSnapshot);
    }

    public Builder current() {
        return new Builder((Snapshot)this.currentSnapshot);
    }

    public void resetTraceConfig() {
        this.currentSnapshot = this.initialSnapshot;
        DynamicConfig.reportConfigChange(this.initialSnapshot);
    }

    public String toString() {
        return ((Snapshot)this.currentSnapshot).toString();
    }

    static Map<String, String> cleanMapping(Collection<? extends Map.Entry<String, String>> mapping, Function<Map.Entry<String, String>, String> keyMapper, Function<Map.Entry<String, String>, String> valueMapper) {
        HashMap<String, String> cleanedMapping = new HashMap<String, String>(mapping.size() * 4 / 3);
        for (Map.Entry<String, String> entry : mapping) {
            cleanedMapping.put(keyMapper.apply(entry), valueMapper.apply(entry));
        }
        return CollectionUtils.tryMakeImmutableMap(cleanedMapping);
    }

    static String key(Map.Entry<String, String> association) {
        return ConfigStrings.trim(association.getKey());
    }

    static String value(Map.Entry<String, String> association) {
        return ConfigStrings.trim(association.getValue());
    }

    static String lowerKey(Map.Entry<String, String> association) {
        return DynamicConfig.key(association).toLowerCase(Locale.ROOT);
    }

    static String requestTag(Map.Entry<String, String> association) {
        String requestTag = DynamicConfig.value(association);
        if (requestTag.isEmpty()) {
            requestTag = "http.request.headers." + ConfigStrings.normalizedHeaderTag(association.getKey());
        }
        return requestTag;
    }

    static String responseTag(Map.Entry<String, String> association) {
        String responseTag = DynamicConfig.value(association);
        if (responseTag.isEmpty()) {
            responseTag = "http.response.headers." + ConfigStrings.normalizedHeaderTag(association.getKey());
        }
        return responseTag;
    }

    static void reportConfigChange(Snapshot newSnapshot) {
        HashMap<String, Object> update = new HashMap<String, Object>();
        update.put("trace.debug", rootLogger.isDebugEnabled());
        update.put("runtime.metrics.enabled", newSnapshot.runtimeMetricsEnabled);
        update.put("logs.injection.enabled", newSnapshot.logsInjectionEnabled);
        update.put("data.streams.enabled", newSnapshot.dataStreamsEnabled);
        update.put("service.mapping", newSnapshot.serviceMapping);
        update.put("trace.request_header.tags", newSnapshot.requestHeaderTags);
        update.put("trace.response_header.tags", newSnapshot.responseHeaderTags);
        update.put("trace.header.baggage", newSnapshot.baggageMapping);
        update.put("trace.sampling.rules", newSnapshot.traceSamplingRulesJson);
        DynamicConfig.maybePut(update, "trace.sample.rate", newSnapshot.traceSampleRate);
        ConfigCollector.get().putRemote(update);
    }

    private static void maybePut(Map<String, Object> update, String key, Object value) {
        if (null != value) {
            update.put(key, value);
        }
    }

    public static class Snapshot
    implements TraceConfig {
        final boolean tracingEnabled;
        final boolean runtimeMetricsEnabled;
        final boolean logsInjectionEnabled;
        final boolean dataStreamsEnabled;
        final Map<String, String> serviceMapping;
        final Map<String, String> requestHeaderTags;
        final Map<String, String> responseHeaderTags;
        final Map<String, String> baggageMapping;
        final List<? extends SamplingRule.SpanSamplingRule> spanSamplingRules;
        final List<? extends SamplingRule.TraceSamplingRule> traceSamplingRules;
        final String traceSamplingRulesJson;
        final Double traceSampleRate;
        final Map<String, String> tracingTags;
        final String preferredServiceName;

        protected Snapshot(Builder builder, Snapshot oldSnapshot) {
            this.tracingEnabled = builder.tracingEnabled;
            this.runtimeMetricsEnabled = builder.runtimeMetricsEnabled;
            this.logsInjectionEnabled = builder.logsInjectionEnabled;
            this.dataStreamsEnabled = builder.dataStreamsEnabled;
            this.serviceMapping = Snapshot.nullToEmpty(builder.serviceMapping);
            this.requestHeaderTags = Snapshot.nullToEmpty(builder.requestHeaderTags);
            this.responseHeaderTags = Snapshot.nullToEmpty(builder.responseHeaderTags);
            this.baggageMapping = Snapshot.nullToEmpty(builder.baggageMapping);
            this.spanSamplingRules = Snapshot.nullToEmpty(builder.spanSamplingRules);
            this.traceSamplingRules = Snapshot.nullToEmpty(builder.traceSamplingRules);
            this.traceSamplingRulesJson = builder.traceSamplingRulesJson;
            this.traceSampleRate = builder.traceSampleRate;
            this.tracingTags = Snapshot.nullToEmpty(builder.tracingTags);
            this.preferredServiceName = builder.preferredServiceName;
        }

        private static <K, V> Map<K, V> nullToEmpty(Map<K, V> mapping) {
            return null != mapping ? mapping : Collections.emptyMap();
        }

        private static <V> List<V> nullToEmpty(List<V> list) {
            return null != list ? list : Collections.emptyList();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.tracingEnabled;
        }

        @Override
        public boolean isRuntimeMetricsEnabled() {
            return this.runtimeMetricsEnabled;
        }

        @Override
        public boolean isLogsInjectionEnabled() {
            return this.logsInjectionEnabled;
        }

        @Override
        public boolean isDataStreamsEnabled() {
            return this.dataStreamsEnabled;
        }

        @Override
        public Map<String, String> getServiceMapping() {
            return this.serviceMapping;
        }

        @Override
        public Map<String, String> getRequestHeaderTags() {
            return this.requestHeaderTags;
        }

        @Override
        public Map<String, String> getResponseHeaderTags() {
            return this.responseHeaderTags;
        }

        @Override
        public Map<String, String> getBaggageMapping() {
            return this.baggageMapping;
        }

        @Override
        public Double getTraceSampleRate() {
            return this.traceSampleRate;
        }

        @Override
        public String getPreferredServiceName() {
            return this.preferredServiceName;
        }

        @Override
        public List<? extends SamplingRule.SpanSamplingRule> getSpanSamplingRules() {
            return this.spanSamplingRules;
        }

        @Override
        public List<? extends SamplingRule.TraceSamplingRule> getTraceSamplingRules() {
            return this.traceSamplingRules;
        }

        @Override
        public Map<String, String> getTracingTags() {
            return this.tracingTags;
        }

        public String toString() {
            return "DynamicConfig{debugEnabled=" + rootLogger.isDebugEnabled() + ", runtimeMetricsEnabled=" + this.runtimeMetricsEnabled + ", logsInjectionEnabled=" + this.logsInjectionEnabled + ", dataStreamsEnabled=" + this.dataStreamsEnabled + ", serviceMapping=" + this.serviceMapping + ", requestHeaderTags=" + this.requestHeaderTags + ", responseHeaderTags=" + this.responseHeaderTags + ", baggageMapping=" + this.baggageMapping + ", spanSamplingRules=" + this.spanSamplingRules + ", traceSamplingRules=" + this.traceSamplingRulesJson + ", traceSampleRate=" + this.traceSampleRate + ", tracingTags=" + this.tracingTags + ", preferredServiceName=" + this.preferredServiceName + '}';
        }
    }

    public final class Builder {
        boolean tracingEnabled;
        boolean runtimeMetricsEnabled;
        boolean logsInjectionEnabled;
        boolean dataStreamsEnabled;
        Map<String, String> serviceMapping;
        Map<String, String> requestHeaderTags;
        Map<String, String> responseHeaderTags;
        Map<String, String> tracingTags;
        Map<String, String> baggageMapping;
        List<? extends SamplingRule.SpanSamplingRule> spanSamplingRules;
        List<? extends SamplingRule.TraceSamplingRule> traceSamplingRules;
        String traceSamplingRulesJson;
        Double traceSampleRate;
        String preferredServiceName;

        Builder() {
        }

        Builder(Snapshot snapshot) {
            this.tracingEnabled = snapshot.tracingEnabled;
            this.runtimeMetricsEnabled = snapshot.runtimeMetricsEnabled;
            this.logsInjectionEnabled = snapshot.logsInjectionEnabled;
            this.dataStreamsEnabled = snapshot.dataStreamsEnabled;
            this.serviceMapping = snapshot.serviceMapping;
            this.requestHeaderTags = snapshot.requestHeaderTags;
            this.responseHeaderTags = snapshot.responseHeaderTags;
            this.baggageMapping = snapshot.baggageMapping;
            this.spanSamplingRules = snapshot.spanSamplingRules;
            this.traceSamplingRules = snapshot.traceSamplingRules;
            this.traceSamplingRulesJson = snapshot.traceSamplingRulesJson;
            this.traceSampleRate = snapshot.traceSampleRate;
            this.tracingTags = snapshot.tracingTags;
            this.preferredServiceName = snapshot.preferredServiceName;
        }

        public Builder setRuntimeMetricsEnabled(boolean runtimeMetricsEnabled) {
            this.runtimeMetricsEnabled = runtimeMetricsEnabled;
            return this;
        }

        public Builder setLogsInjectionEnabled(boolean logsInjectionEnabled) {
            this.logsInjectionEnabled = logsInjectionEnabled;
            return this;
        }

        public Builder setDataStreamsEnabled(boolean dataStreamsEnabled) {
            this.dataStreamsEnabled = dataStreamsEnabled;
            return this;
        }

        public Builder setServiceMapping(Map<String, String> serviceMapping) {
            return this.setServiceMapping(serviceMapping.entrySet());
        }

        public Builder setHeaderTags(Map<String, String> headerTags) {
            if (Config.get().getRequestHeaderTags().equals(headerTags) && !Config.get().getResponseHeaderTags().equals(headerTags)) {
                this.requestHeaderTags = Config.get().getRequestHeaderTags();
                this.responseHeaderTags = Config.get().getResponseHeaderTags();
                return this;
            }
            return this.setHeaderTags(headerTags.entrySet());
        }

        public Builder setBaggageMapping(Map<String, String> baggageMapping) {
            return this.setBaggageMapping(baggageMapping.entrySet());
        }

        public Builder setServiceMapping(Collection<? extends Map.Entry<String, String>> serviceMapping) {
            this.serviceMapping = DynamicConfig.cleanMapping(serviceMapping, KEY, VALUE);
            return this;
        }

        public Builder setHeaderTags(Collection<? extends Map.Entry<String, String>> headerTags) {
            this.requestHeaderTags = DynamicConfig.cleanMapping(headerTags, LOWER_KEY, REQUEST_TAG);
            this.responseHeaderTags = DynamicConfig.cleanMapping(headerTags, LOWER_KEY, RESPONSE_TAG);
            return this;
        }

        public Builder setBaggageMapping(Collection<? extends Map.Entry<String, String>> baggageMapping) {
            this.baggageMapping = DynamicConfig.cleanMapping(baggageMapping, LOWER_KEY, VALUE);
            return this;
        }

        public Builder setTraceSampleRate(Double traceSampleRate) {
            this.traceSampleRate = traceSampleRate;
            return this;
        }

        public Builder setSpanSamplingRules(List<? extends SamplingRule.SpanSamplingRule> spanSamplingRules) {
            this.spanSamplingRules = spanSamplingRules;
            return this;
        }

        public Builder setTraceSamplingRules(List<? extends SamplingRule.TraceSamplingRule> traceSamplingRules, String traceSamplingRulesJson) {
            this.traceSamplingRules = traceSamplingRules;
            this.traceSamplingRulesJson = traceSamplingRulesJson;
            return this;
        }

        public Builder setTracingTags(Map<String, String> tracingTags) {
            this.tracingTags = tracingTags;
            return this;
        }

        public Builder setTracingEnabled(boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        public Builder setPreferredServiceName(String preferredServiceName) {
            this.preferredServiceName = preferredServiceName;
            return this;
        }

        public DynamicConfig<S> apply() {
            Object oldSnapshot = DynamicConfig.this.currentSnapshot;
            Snapshot newSnapshot = (Snapshot)DynamicConfig.this.snapshotFactory.apply(this, oldSnapshot);
            if (null == oldSnapshot) {
                DynamicConfig.this.initialSnapshot = newSnapshot;
                DynamicConfig.this.currentSnapshot = newSnapshot;
            } else {
                DynamicConfig.this.currentSnapshot = newSnapshot;
                DynamicConfig.reportConfigChange(newSnapshot);
            }
            return DynamicConfig.this;
        }
    }
}

