/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.utils;

import java.util.Arrays;

public final class ClassNameFilter {
    private static final int MAX_CAPACITY = 0x100000;
    private static final int MIN_CAPACITY = 256;
    private static final int MAX_HASH_ATTEMPTS = 10;
    private final long[] members;
    private final int slotMask;

    public ClassNameFilter(int capacity) {
        if (capacity < 256) {
            capacity = 256;
        } else if (capacity > 0x100000) {
            capacity = 0x100000;
        }
        this.slotMask = -1 >>> Integer.numberOfLeadingZeros(capacity - 1);
        this.members = new long[this.slotMask + 1];
    }

    public boolean contains(CharSequence className) {
        int hash = className.hashCode();
        long[] members = this.members;
        int slotMask = this.slotMask;
        int i = 1;
        int h = hash;
        while (true) {
            block6: {
                block5: {
                    long codeAndHash;
                    if ((codeAndHash = members[slotMask & h]) == 0L) break block5;
                    if ((int)codeAndHash == hash) {
                        return ClassNameFilter.checkClassCode(className, (int)(codeAndHash >>> 32));
                    }
                    if (i < 10) break block6;
                }
                return false;
            }
            ++i;
            h = ClassNameFilter.rehash(h);
        }
    }

    public void add(String className) {
        int hash = className.hashCode();
        long[] members = this.members;
        int slotMask = this.slotMask;
        long codeAndHash = (long)ClassNameFilter.classCode(className) << 32 | 0xFFFFFFFFL & (long)hash;
        int i = 1;
        int h = hash;
        while (true) {
            block6: {
                block5: {
                    int slot;
                    long existing;
                    if ((existing = members[slot = slotMask & h]) == 0L) break block5;
                    if ((int)existing == (int)codeAndHash) {
                        return;
                    }
                    if (i < 10) break block6;
                    slot = slotMask & hash;
                }
                members[slot] = codeAndHash;
                return;
            }
            ++i;
            h = ClassNameFilter.rehash(h);
        }
    }

    public void clear() {
        Arrays.fill(this.members, 0L);
    }

    private static int classCode(String className) {
        int start = className.lastIndexOf(46) + 1;
        int end = className.length() - 1;
        return (0xFF & className.charAt(end)) << 24 | (0xFF & className.charAt(start)) << 16 | (0xFF & end - start) << 8 | 0xFF & start;
    }

    private static boolean checkClassCode(CharSequence className, int code) {
        int start = 0xFF & code;
        int end = className.length() - 1;
        return end - start == (0xFF & code >> 8) && className.charAt(start) == (0xFF & code >> 16) && className.charAt(end) == (0xFF & code >> 24);
    }

    private static int rehash(int oldHash) {
        return Integer.reverseBytes(oldHash * -1640532531) * -1640532531;
    }
}

