/*
 * Decompiled with CFR 0.152.
 */
package datadog.instrument.classmatch;

import datadog.instrument.classmatch.AccessMatcher;
import datadog.instrument.classmatch.InternalMatchers;
import datadog.instrument.classmatch.MethodOutline;
import datadog.instrument.classmatch.TypeMatcher;
import datadog.instrument.classmatch.TypeString;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;

@FunctionalInterface
public interface MethodMatcher
extends Predicate<MethodOutline> {
    public static MethodMatcher method() {
        return InternalMatchers.ALL_METHODS;
    }

    public static MethodMatcher method(String name) {
        return m -> name.equals(m.methodName);
    }

    public static MethodMatcher method(Predicate<String> nameMatcher) {
        return m -> nameMatcher.test(m.methodName);
    }

    public static MethodMatcher constructor() {
        return m -> "<init>".equals(m.methodName);
    }

    public static MethodMatcher staticInitializer() {
        return m -> "<clinit>".equals(m.methodName);
    }

    default public MethodMatcher access(AccessMatcher accessMatcher) {
        return this.and(m -> accessMatcher.test(m.access));
    }

    default public MethodMatcher noParameters() {
        return this.and(m -> m.descriptor.charAt(1) == ')');
    }

    default public MethodMatcher parameters(int paramCount) {
        if (paramCount == 0) {
            return this.noParameters();
        }
        return this.and(m -> m.parameterCount() == paramCount);
    }

    default public MethodMatcher parameters(String ... paramTypes) {
        StringBuilder buf = new StringBuilder().append('(');
        for (String paramType : paramTypes) {
            buf.append(InternalMatchers.descriptor(paramType));
        }
        String prefix = buf.append(')').toString();
        return this.and(m -> m.descriptor.startsWith(prefix));
    }

    default public MethodMatcher parameters(Class<?> ... paramTypes) {
        StringBuilder buf = new StringBuilder().append('(');
        for (Class<?> paramType : paramTypes) {
            buf.append(InternalMatchers.descriptor(paramType));
        }
        String prefix = buf.append(')').toString();
        return this.and(m -> m.descriptor.startsWith(prefix));
    }

    default public MethodMatcher parameter(int paramIndex, String paramType) {
        String paramDescriptor = InternalMatchers.descriptor(paramType);
        if (paramIndex == 0) {
            return this.and(m -> m.descriptor.startsWith(paramDescriptor, 1));
        }
        return this.and(m -> InternalMatchers.hasParamDescriptor(m, paramIndex, paramDescriptor));
    }

    default public MethodMatcher parameter(int paramIndex, Class<?> paramType) {
        String paramDescriptor = InternalMatchers.descriptor(paramType);
        if (paramIndex == 0) {
            return this.and(m -> m.descriptor.startsWith(paramDescriptor, 1));
        }
        return this.and(m -> InternalMatchers.hasParamDescriptor(m, paramIndex, paramDescriptor));
    }

    default public MethodMatcher parameter(int paramIndex, TypeMatcher typeMatcher) {
        return this.and(m -> {
            TypeString paramType = m.parameterTypeString(paramIndex);
            return paramType != null && typeMatcher.test(paramType);
        });
    }

    default public MethodMatcher returning(String returnType) {
        String returnDescriptor = InternalMatchers.descriptor(returnType);
        return this.and(m -> m.descriptor.endsWith(returnDescriptor));
    }

    default public MethodMatcher returning(Class<?> returnType) {
        String returnDescriptor = InternalMatchers.descriptor(returnType);
        return this.and(m -> m.descriptor.endsWith(returnDescriptor));
    }

    default public MethodMatcher returning(TypeMatcher typeMatcher) {
        return this.and(m -> {
            TypeString returnType = m.returnTypeString();
            return returnType != null && typeMatcher.test(returnType);
        });
    }

    default public MethodMatcher annotatedWith(String annotationType) {
        Predicate<String[]> annotationMatcher = InternalMatchers.declaresAnnotation(annotationType);
        return this.and(m -> annotationMatcher.test(m.annotations));
    }

    default public MethodMatcher annotatedWith(String ... annotationTypes) {
        return this.annotatedWith(Arrays.asList(annotationTypes));
    }

    default public MethodMatcher annotatedWith(Collection<String> annotationTypes) {
        Predicate<String[]> annotationMatcher = InternalMatchers.declaresAnnotationOneOf(annotationTypes);
        return this.and(m -> annotationMatcher.test(m.annotations));
    }

    default public MethodMatcher and(MethodMatcher other) {
        return new InternalMatchers.MethodConjunction(this, other);
    }

    default public MethodMatcher or(MethodMatcher other) {
        return new InternalMatchers.MethodDisjunction(this, other);
    }
}

