/*
 * Decompiled with CFR 0.152.
 */
package datadog.context;

import datadog.context.Context;
import datadog.context.ContextManager;
import datadog.context.ContextProviders;
import datadog.context.ContextScope;
import datadog.context.ThreadLocalContextManager;

final class TestContextManager
implements ContextManager {
    private static final ContextManager TEST_INSTANCE = new TestContextManager();

    private TestContextManager() {
    }

    static boolean register() {
        ContextProviders.customManager = TEST_INSTANCE;
        return ContextProviders.manager() == TEST_INSTANCE;
    }

    @Override
    public Context current() {
        return TestContextManager.delegate().current();
    }

    @Override
    public ContextScope attach(Context context) {
        return TestContextManager.delegate().attach(context);
    }

    @Override
    public Context swap(Context context) {
        return TestContextManager.delegate().swap(context);
    }

    private static ContextManager delegate() {
        ContextManager delegate = ContextProviders.customManager;
        if (delegate == TEST_INSTANCE) {
            return ThreadLocalContextManager.INSTANCE;
        }
        return delegate;
    }
}

