/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.annotation.Nonnull;

public class ConcurrentEnumMap<K extends Enum<K>, V>
implements Map<K, V> {
    private final K[] enumConstants;
    private final AtomicReferenceArray<V> values;

    public ConcurrentEnumMap(Class<K> enumClass) {
        this.enumConstants = (Enum[])enumClass.getEnumConstants();
        this.values = new AtomicReferenceArray(this.enumConstants.length);
    }

    private int indexOf(Object key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null");
        }
        if (key.getClass() != ((Enum)this.enumConstants[0]).getDeclaringClass()) {
            throw new IllegalArgumentException("Key has wrong enum type");
        }
        Enum castKey = (Enum)key;
        return castKey.ordinal();
    }

    @Override
    public V get(Object key) {
        int idx = this.indexOf(key);
        return this.values.get(idx);
    }

    @Override
    public V put(K key, V value) {
        int idx = this.indexOf(key);
        return this.values.getAndSet(idx, value);
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put((K)((Enum)e.getKey()), e.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        int idx = this.indexOf(key);
        return this.values.getAndSet(idx, null);
    }

    @Override
    public V putIfAbsent(@Nonnull K key, V value) {
        int idx = this.indexOf(key);
        do {
            V existing;
            if ((existing = this.values.get(idx)) == null) continue;
            return existing;
        } while (!this.values.compareAndSet(idx, null, value));
        return null;
    }

    @Override
    public boolean remove(@Nonnull Object key, Object value) {
        int idx = this.indexOf(key);
        V cur = this.values.get(idx);
        if (cur == null || !cur.equals(value)) {
            return false;
        }
        return this.values.compareAndSet(idx, cur, null);
    }

    @Override
    public boolean replace(@Nonnull K key, @Nonnull V oldValue, @Nonnull V newValue) {
        int idx = this.indexOf(key);
        return this.values.compareAndSet(idx, oldValue, newValue);
    }

    @Override
    public V replace(@Nonnull K key, @Nonnull V value) {
        V cur;
        int idx = this.indexOf(key);
        do {
            if ((cur = this.values.get(idx)) != null) continue;
            return null;
        } while (!this.values.compareAndSet(idx, cur, value));
        return cur;
    }

    @Override
    public int size() {
        int count = 0;
        for (int i = 0; i < this.values.length(); ++i) {
            if (this.values.get(i) == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.values.length(); ++i) {
            if (this.values.get(i) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 0; i < this.values.length(); ++i) {
            V v = this.values.get(i);
            if (v == null || !v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.values.length(); ++i) {
            this.values.set(i, null);
        }
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        EnumSet<K> keys = EnumSet.noneOf(((Enum)this.enumConstants[0]).getDeclaringClass());
        for (int i = 0; i < this.values.length(); ++i) {
            if (this.values.get(i) == null) continue;
            keys.add(this.enumConstants[i]);
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        ArrayList<V> list = new ArrayList<V>();
        for (int i = 0; i < this.values.length(); ++i) {
            V value = this.values.get(i);
            if (value == null) continue;
            list.add(value);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<AbstractMap.SimpleEntry<K, V>> entrySet = new HashSet<AbstractMap.SimpleEntry<K, V>>();
        for (int i = 0; i < this.enumConstants.length; ++i) {
            V value = this.values.get(i);
            if (value == null) continue;
            K key = this.enumConstants[i];
            entrySet.add(new AbstractMap.SimpleEntry<K, V>(key, value));
        }
        return Collections.unmodifiableSet(entrySet);
    }
}

