/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.logging.ddlogger;

import datadog.slf4j.Logger;
import datadog.slf4j.Marker;
import datadog.slf4j.helpers.FormattingTuple;
import datadog.slf4j.helpers.MessageFormatter;
import datadog.trace.logging.LogLevel;
import datadog.trace.logging.LoggerHelper;

public class DDLogger
implements Logger {
    private final String name;
    private final LoggerHelper helper;

    public DDLogger(LoggerHelper helper, String name) {
        this.name = name;
        this.helper = helper;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.helper.enabled(LogLevel.TRACE, null);
    }

    @Override
    public void trace(String msg) {
        this.log(LogLevel.TRACE, null, msg, null);
    }

    @Override
    public void trace(String format, Object arg) {
        this.formatLog(LogLevel.TRACE, (Marker)null, format, arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        this.formatLog(LogLevel.TRACE, (Marker)null, format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.formatLog(LogLevel.TRACE, (Marker)null, format, arguments);
    }

    @Override
    public void trace(String msg, Throwable t) {
        this.log(LogLevel.TRACE, null, msg, t);
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        return this.helper.enabled(LogLevel.TRACE, marker);
    }

    @Override
    public void trace(Marker marker, String msg) {
        this.log(LogLevel.TRACE, marker, msg, null);
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        this.formatLog(LogLevel.TRACE, marker, format, arg);
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.formatLog(LogLevel.TRACE, marker, format, arg1, arg2);
    }

    @Override
    public void trace(Marker marker, String format, Object ... arguments) {
        this.formatLog(LogLevel.TRACE, marker, format, arguments);
    }

    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        this.log(LogLevel.TRACE, marker, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.helper.enabled(LogLevel.DEBUG, null);
    }

    @Override
    public void debug(String msg) {
        this.log(LogLevel.DEBUG, null, msg, null);
    }

    @Override
    public void debug(String format, Object arg) {
        this.formatLog(LogLevel.DEBUG, (Marker)null, format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        this.formatLog(LogLevel.DEBUG, (Marker)null, format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.formatLog(LogLevel.DEBUG, (Marker)null, format, arguments);
    }

    @Override
    public void debug(String msg, Throwable t) {
        this.log(LogLevel.DEBUG, null, msg, t);
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        return this.helper.enabled(LogLevel.DEBUG, marker);
    }

    @Override
    public void debug(Marker marker, String msg) {
        this.log(LogLevel.DEBUG, marker, msg, null);
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        this.formatLog(LogLevel.DEBUG, marker, format, arg);
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.formatLog(LogLevel.DEBUG, marker, format, arg1, arg2);
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        this.formatLog(LogLevel.DEBUG, marker, format, arguments);
    }

    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        this.log(LogLevel.DEBUG, marker, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.helper.enabled(LogLevel.INFO, null);
    }

    @Override
    public void info(String msg) {
        this.log(LogLevel.INFO, null, msg, null);
    }

    @Override
    public void info(String format, Object arg) {
        this.formatLog(LogLevel.INFO, (Marker)null, format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        this.formatLog(LogLevel.INFO, (Marker)null, format, arg1, arg2);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.formatLog(LogLevel.INFO, (Marker)null, format, arguments);
    }

    @Override
    public void info(String msg, Throwable t) {
        this.log(LogLevel.INFO, null, msg, t);
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        return this.helper.enabled(LogLevel.INFO, marker);
    }

    @Override
    public void info(Marker marker, String msg) {
        this.log(LogLevel.INFO, marker, msg, null);
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        this.formatLog(LogLevel.INFO, marker, format, arg);
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.formatLog(LogLevel.INFO, marker, format, arg1, arg2);
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        this.formatLog(LogLevel.INFO, marker, format, arguments);
    }

    @Override
    public void info(Marker marker, String msg, Throwable t) {
        this.log(LogLevel.INFO, marker, msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.helper.enabled(LogLevel.WARN, null);
    }

    @Override
    public void warn(String msg) {
        this.log(LogLevel.WARN, null, msg, null);
    }

    @Override
    public void warn(String format, Object arg) {
        this.formatLog(LogLevel.WARN, (Marker)null, format, arg);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        this.formatLog(LogLevel.WARN, (Marker)null, format, arg1, arg2);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.formatLog(LogLevel.WARN, (Marker)null, format, arguments);
    }

    @Override
    public void warn(String msg, Throwable t) {
        this.log(LogLevel.WARN, null, msg, t);
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        return this.helper.enabled(LogLevel.WARN, marker);
    }

    @Override
    public void warn(Marker marker, String msg) {
        this.log(LogLevel.WARN, marker, msg, null);
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        this.formatLog(LogLevel.WARN, marker, format, arg);
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.formatLog(LogLevel.WARN, marker, format, arg1, arg2);
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        this.formatLog(LogLevel.WARN, marker, format, arguments);
    }

    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        this.log(LogLevel.WARN, marker, msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.helper.enabled(LogLevel.ERROR, null);
    }

    @Override
    public void error(String msg) {
        this.log(LogLevel.ERROR, null, msg, null);
    }

    @Override
    public void error(String format, Object arg) {
        this.formatLog(LogLevel.ERROR, (Marker)null, format, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        this.formatLog(LogLevel.ERROR, (Marker)null, format, arg1, arg2);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.formatLog(LogLevel.ERROR, (Marker)null, format, arguments);
    }

    @Override
    public void error(String msg, Throwable t) {
        this.log(LogLevel.ERROR, null, msg, t);
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        return this.helper.enabled(LogLevel.ERROR, marker);
    }

    @Override
    public void error(Marker marker, String msg) {
        this.log(LogLevel.ERROR, marker, msg, null);
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        this.formatLog(LogLevel.ERROR, marker, format, arg);
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.formatLog(LogLevel.ERROR, marker, format, arg1, arg2);
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        this.formatLog(LogLevel.ERROR, marker, format, arguments);
    }

    @Override
    public void error(Marker marker, String msg, Throwable t) {
        this.log(LogLevel.ERROR, marker, msg, t);
    }

    public void formatLog(LogLevel level, Marker marker, String format, Object arg) {
        if (!this.helper.enabled(level, marker)) {
            return;
        }
        FormattingTuple tuple = MessageFormatter.format(format, arg);
        this.alwaysLog(level, marker, tuple.getMessage(), tuple.getThrowable());
    }

    public void formatLog(LogLevel level, Marker marker, String format, Object arg1, Object arg2) {
        if (!this.helper.enabled(level, marker)) {
            return;
        }
        FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
        this.alwaysLog(level, marker, tuple.getMessage(), tuple.getThrowable());
    }

    public void formatLog(LogLevel level, Marker marker, String format, Object ... arguments) {
        if (!this.helper.enabled(level, marker)) {
            return;
        }
        FormattingTuple tuple = MessageFormatter.arrayFormat(format, arguments);
        this.alwaysLog(level, marker, tuple.getMessage(), tuple.getThrowable());
    }

    protected void log(LogLevel level, Marker marker, String msg, Throwable t) {
        if (!this.helper.enabled(level, marker)) {
            return;
        }
        this.helper.log(level, marker, msg, t);
    }

    private void alwaysLog(LogLevel level, Marker marker, String msg, Throwable t) {
        this.helper.log(level, marker, msg, t);
    }
}

