/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.rum;

import datadog.trace.api.Config;
import datadog.trace.api.InstrumenterConfig;
import datadog.trace.api.StatsDClient;
import datadog.trace.api.cache.DDCache;
import datadog.trace.api.cache.DDCaches;
import datadog.trace.api.rum.RumInjectorConfig;
import datadog.trace.api.rum.RumInjectorMetrics;
import datadog.trace.api.rum.RumTelemetryCollector;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class RumInjector {
    private static final RumInjector INSTANCE = new RumInjector(Config.get(), InstrumenterConfig.get());
    private static final String MARKER = "</head>";
    private static final char[] MARKER_CHARS = "</head>".toCharArray();
    private static final Function<String, byte[]> MARKER_BYTES = charset -> {
        try {
            return MARKER.getBytes((String)charset);
        }
        catch (Throwable t) {
            return null;
        }
    };
    private final boolean enabled;
    private final String snippet;
    private final char[] snippetChars;
    private final DDCache<String, byte[]> snippetCache;
    private final DDCache<String, byte[]> markerCache;
    private final Function<String, byte[]> snippetBytes;
    private static volatile RumTelemetryCollector telemetryCollector = RumTelemetryCollector.NO_OP;

    RumInjector(Config config, InstrumenterConfig instrumenterConfig) {
        boolean rumEnabled = instrumenterConfig.isRumEnabled();
        RumInjectorConfig injectorConfig = config.getRumInjectorConfig();
        if (rumEnabled && injectorConfig != null) {
            this.enabled = true;
            this.snippet = injectorConfig.getSnippet();
            this.snippetCache = DDCaches.newFixedSizeCache(16);
            this.markerCache = DDCaches.newFixedSizeCache(16);
            this.snippetChars = this.snippet.toCharArray();
            this.snippetBytes = charset -> {
                try {
                    return this.snippet.getBytes((String)charset);
                }
                catch (Throwable t) {
                    return null;
                }
            };
        } else {
            this.enabled = false;
            this.snippet = null;
            this.snippetCache = null;
            this.markerCache = null;
            this.snippetBytes = null;
            this.snippetChars = null;
        }
    }

    public static RumInjector get() {
        return INSTANCE;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public char[] getSnippetChars() {
        if (!this.enabled) {
            return null;
        }
        return this.snippetChars;
    }

    @Nullable
    public byte[] getSnippetBytes(String encoding) {
        if (!this.enabled) {
            return null;
        }
        return this.snippetCache.computeIfAbsent(encoding, this.snippetBytes);
    }

    @Nullable
    public char[] getMarkerChars() {
        if (!this.enabled) {
            return null;
        }
        return MARKER_CHARS;
    }

    @Nullable
    public byte[] getMarkerBytes(String encoding) {
        if (!this.enabled) {
            return null;
        }
        return this.markerCache.computeIfAbsent(encoding, MARKER_BYTES);
    }

    public static void enableTelemetry(StatsDClient statsDClient) {
        if (statsDClient != null) {
            RumInjectorMetrics metrics = new RumInjectorMetrics(statsDClient);
            telemetryCollector = metrics;
            if (INSTANCE.isEnabled()) {
                telemetryCollector.onInitializationSucceed();
            }
        } else {
            telemetryCollector = RumTelemetryCollector.NO_OP;
        }
    }

    public static void shutdownTelemetry() {
        telemetryCollector.close();
        telemetryCollector = RumTelemetryCollector.NO_OP;
    }

    public static void setTelemetryCollector(RumTelemetryCollector collector) {
        telemetryCollector = collector != null ? collector : RumTelemetryCollector.NO_OP;
    }

    public static RumTelemetryCollector getTelemetryCollector() {
        return telemetryCollector;
    }
}

