/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.logging.simplelogger;

import datadog.json.JsonWriter;
import datadog.slf4j.Marker;
import datadog.trace.logging.LogLevel;
import datadog.trace.logging.LoggerHelper;
import datadog.trace.logging.simplelogger.SLCompatFactory;
import datadog.trace.logging.simplelogger.SLCompatSettings;

class SLCompatHelper
extends LoggerHelper {
    private final String logName;
    private final LogLevel logLevel;
    private final SLCompatSettings settings;

    SLCompatHelper(String name, SLCompatSettings settings) {
        this(settings.logNameForName(name), settings.logLevelForName(name), settings);
    }

    SLCompatHelper(String logName, LogLevel logLevel, SLCompatSettings settings) {
        this.logName = logName;
        this.logLevel = logLevel;
        this.settings = settings;
    }

    @Override
    public boolean enabled(LogLevel level, Marker marker) {
        return level.isEnabled(this.logLevel);
    }

    @Override
    public void log(LogLevel level, Marker marker, String message, Throwable t) {
        long timeMillis = Integer.MIN_VALUE;
        if (this.settings.showDateTime) {
            timeMillis = System.currentTimeMillis();
        }
        if (this.settings.jsonEnabled) {
            this.logJson(level, marker, SLCompatFactory.START_TIME, timeMillis, message, t);
        } else {
            this.log(level, marker, SLCompatFactory.START_TIME, timeMillis, message, t);
        }
    }

    void log(LogLevel level, Marker marker, long startTimeMillis, long timeMillis, String message, Throwable t) {
        String threadName = null;
        if (this.settings.showThreadName) {
            threadName = Thread.currentThread().getName();
        }
        this.log(level, marker, startTimeMillis, timeMillis, threadName, message, t);
    }

    void log(LogLevel level, Marker marker, long startTimeMillis, long timeMillis, String threadName, String message, Throwable t) {
        StringBuilder buf = new StringBuilder(32);
        if (timeMillis >= 0L && this.settings.showDateTime) {
            this.settings.dateTimeFormatter.appendFormattedDate(buf, timeMillis, startTimeMillis);
            buf.append(' ');
        }
        if (this.settings.showThreadName && threadName != null) {
            buf.append('[');
            buf.append(threadName);
            buf.append("] ");
        }
        if (this.settings.levelInBrackets) {
            buf.append('[');
        }
        if (this.settings.warnLevelString != null && level == LogLevel.WARN) {
            buf.append(this.settings.warnLevelString);
        } else if (marker != null) {
            buf.append(marker.getName());
        } else {
            buf.append(level.name());
        }
        if (this.settings.levelInBrackets) {
            buf.append(']');
        }
        buf.append(' ');
        if (!this.logName.isEmpty()) {
            buf.append(this.logName).append(" - ");
        }
        buf.append(message);
        if (this.settings.embedException && t != null) {
            this.embedException(buf, t);
        }
        this.settings.printStream.println(buf);
        if (!this.settings.embedException && t != null) {
            t.printStackTrace(this.settings.printStream);
        }
    }

    private void embedException(StringBuilder buf, Throwable t) {
        buf.append(" [exception:");
        buf.append(t.toString());
        buf.append(".");
        for (StackTraceElement element : t.getStackTrace()) {
            buf.append(" at ");
            buf.append(element.toString());
        }
        buf.append("]");
    }

    void logJson(LogLevel level, Marker marker, long startTimeMillis, long timeMillis, String message, Throwable t) {
        String threadName = null;
        if (this.settings.showThreadName) {
            threadName = Thread.currentThread().getName();
        }
        this.logJson(level, marker, startTimeMillis, timeMillis, threadName, message, t);
    }

    void logJson(LogLevel level, Marker marker, long startTimeMillis, long timeMillis, String threadName, String message, Throwable t) {
        JsonWriter writer = new JsonWriter();
        writer.beginObject();
        writer.name("origin").value("dd.trace");
        if (timeMillis >= 0L && this.settings.showDateTime) {
            writer.name("date");
            StringBuilder buf = new StringBuilder(32);
            this.settings.dateTimeFormatter.appendFormattedDate(buf, timeMillis, startTimeMillis);
            writer.value(buf.toString());
        }
        if (this.settings.showThreadName && threadName != null) {
            writer.name("logger.thread_name").value(threadName);
        }
        writer.name("level");
        if (this.settings.warnLevelString != null && level == LogLevel.WARN) {
            writer.value(this.wrappedValueWithBracketsIfRequested(this.settings.warnLevelString));
        } else if (marker != null) {
            writer.value(this.wrappedValueWithBracketsIfRequested(marker.getName()));
        } else {
            writer.value(this.wrappedValueWithBracketsIfRequested(level.name()));
        }
        if (!this.logName.isEmpty()) {
            writer.name("logger.name").value(this.logName);
        }
        writer.name("message").value(message);
        if (t != null) {
            this.embedExceptionJson(writer, t);
        }
        writer.endObject();
        this.settings.printStream.println(writer);
    }

    private String wrappedValueWithBracketsIfRequested(String value) {
        return this.settings.levelInBrackets ? '[' + value + ']' : value;
    }

    private void embedExceptionJson(JsonWriter writer, Throwable t) {
        writer.name("exception");
        writer.beginObject();
        writer.name("message").value(t.getMessage());
        if (t.getStackTrace().length > 0) {
            writer.name("stackTrace");
            writer.beginArray();
            for (StackTraceElement element : t.getStackTrace()) {
                writer.value(element.toString());
            }
            writer.endArray();
        }
        writer.endObject();
    }
}

