/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.logging;

import datadog.trace.api.Config;
import datadog.trace.api.flare.TracerFlare;
import datadog.trace.logging.PrintStreamWrapper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipOutputStream;

public class LogReporter
implements TracerFlare.Reporter {
    private static final LogReporter INSTANCE = new LogReporter();
    private static final int MAX_LOGFILE_SIZE_MB = 15;
    public static final int MAX_LOGFILE_SIZE_BYTES = 0xF00000;
    private Path capturedLogPath;
    private boolean isFlarePrepared;
    private static File configuredLogFile;
    private static PrintStreamWrapper wrappedPrintStream;

    private LogReporter() {
    }

    public static void register(PrintStreamWrapper printStreamWrapper) {
        wrappedPrintStream = printStreamWrapper;
        LogReporter.register();
    }

    public static void register(File configuredFile) {
        configuredLogFile = configuredFile;
        LogReporter.register();
    }

    private static void register() {
        TracerFlare.addReporter(INSTANCE);
    }

    @Override
    public void prepareForFlare() {
        this.isFlarePrepared = true;
        if (wrappedPrintStream != null) {
            long endMillis = System.currentTimeMillis();
            String captureFilename = "tracer-" + Config.get().getRuntimeId() + "-" + endMillis + ".log";
            try {
                Path tempPath = Paths.get(System.getProperty("java.io.tmpdir"), captureFilename);
                Path parentPath = tempPath.getParent();
                if (parentPath != null && !Files.isDirectory(parentPath, new LinkOption[0])) {
                    Files.createDirectories(parentPath, new FileAttribute[0]);
                }
                this.capturedLogPath = Files.createFile(tempPath, new FileAttribute[0]);
                wrappedPrintStream.startCapturing(this.capturedLogPath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addReportToFlare(ZipOutputStream zip) throws IOException {
        block23: {
            if (configuredLogFile == null) {
                if (this.isFlarePrepared) {
                    try {
                        if (this.capturedLogPath != null) {
                            TracerFlare.addBinary(zip, "tracer.log", Files.readAllBytes(this.capturedLogPath));
                        }
                    }
                    catch (Exception e) {
                        TracerFlare.addText(zip, "tracer.log", "Problem reading temporary tracer log file: " + e.getMessage());
                    }
                } else {
                    TracerFlare.addText(zip, "tracer.log", "No tracer log file specified and no prepare flare event received");
                }
            } else {
                Path path = Paths.get(configuredLogFile.getPath(), new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    try {
                        long size = Files.size(path);
                        if (size > 0xF00000L) {
                            int maxSizeOfSplit = 0x780000;
                            File originalFile = new File(path.toString());
                            try (RandomAccessFile ras = new RandomAccessFile(originalFile, "r");){
                                byte[] buffer = new byte[maxSizeOfSplit];
                                ras.readFully(buffer);
                                TracerFlare.addBinary(zip, "tracer_begin.log", buffer);
                                ras.seek(size - (long)maxSizeOfSplit);
                                ras.readFully(buffer);
                                TracerFlare.addBinary(zip, "tracer_end.log", buffer);
                                break block23;
                            }
                        }
                        TracerFlare.addBinary(zip, "tracer.log", Files.readAllBytes(path));
                    }
                    catch (Throwable e) {
                        TracerFlare.addText(zip, "tracer.log", "Problem collecting tracer log: " + e);
                    }
                }
            }
        }
    }

    @Override
    public void cleanupAfterFlare() {
        this.isFlarePrepared = false;
        if (wrappedPrintStream != null) {
            try {
                wrappedPrintStream.stopCapturing();
                File outputFile = this.capturedLogPath.toFile();
                if (outputFile.exists() && !outputFile.delete()) {
                    throw new RuntimeException("Failed to delete file: " + this.capturedLogPath);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.capturedLogPath = null;
        }
    }
}

