/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.otel.shim.context;

import datadog.context.ContextKey;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AttachableWrapper;
import datadog.trace.bootstrap.otel.context.Context;
import datadog.trace.bootstrap.otel.context.Scope;
import datadog.trace.bootstrap.otel.shim.context.OtelScope;
import datadog.trace.bootstrap.otel.shim.trace.OtelSpan;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class OtelContext
implements Context {
    public static final Context ROOT = new OtelContext(datadog.context.Context.root());
    private static final String OTEL_CONTEXT_SPAN_KEY = "opentelemetry-trace-span-key";
    private static final String OTEL_CONTEXT_ROOT_SPAN_KEY = "opentelemetry-traces-local-root-span";
    private static final Map<datadog.trace.bootstrap.otel.context.ContextKey<?>, ContextKey<?>> DELEGATE_KEYS = new ConcurrentHashMap();
    private final datadog.context.Context delegate;

    public OtelContext(datadog.context.Context delegate) {
        this.delegate = delegate;
    }

    public static Context current() {
        return new OtelContext(datadog.context.Context.current());
    }

    @Override
    public Scope makeCurrent() {
        return new OtelScope(Context.super.makeCurrent(), this.delegate.attach());
    }

    @Override
    @Nullable
    public <V> V get(datadog.trace.bootstrap.otel.context.ContextKey<V> key) {
        AgentSpan span;
        if (OTEL_CONTEXT_SPAN_KEY.equals(key.toString())) {
            AgentSpan span2 = AgentSpan.fromContext(this.delegate);
            if (span2 != null) {
                return (V)OtelContext.toOtelSpan(span2);
            }
        } else if (OTEL_CONTEXT_ROOT_SPAN_KEY.equals(key.toString()) && (span = AgentSpan.fromContext(this.delegate)) != null) {
            return (V)OtelContext.toOtelSpan(span.getLocalRootSpan());
        }
        return (V)this.delegate.get(OtelContext.delegateKey(key));
    }

    @Override
    public <V> Context with(datadog.trace.bootstrap.otel.context.ContextKey<V> key, V value) {
        if (OTEL_CONTEXT_SPAN_KEY.equals(key.toString()) && value instanceof OtelSpan) {
            AgentSpan span = ((OtelSpan)value).asAgentSpan();
            return new OtelContext(this.delegate.with(span));
        }
        return new OtelContext(this.delegate.with(OtelContext.delegateKey(key), value));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.delegate.equals(((OtelContext)o).delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return "OtelContext{delegate=" + this.delegate + '}';
    }

    private static ContextKey delegateKey(datadog.trace.bootstrap.otel.context.ContextKey key) {
        return DELEGATE_KEYS.computeIfAbsent(key, OtelContext::mapByKeyName);
    }

    private static ContextKey mapByKeyName(datadog.trace.bootstrap.otel.context.ContextKey key) {
        return ContextKey.named(key.toString());
    }

    private static OtelSpan toOtelSpan(AgentSpan span) {
        Object wrapper;
        if (span instanceof AttachableWrapper && (wrapper = ((AttachableWrapper)((Object)span)).getWrapper()) instanceof OtelSpan) {
            return (OtelSpan)wrapper;
        }
        return new OtelSpan(span);
    }
}

