/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.trace.bootstrap.ContextStore;
import datadog.trace.bootstrap.WeakMap;

final class WeakMapContextStore<K, V>
implements ContextStore<K, V> {
    private static final int DEFAULT_MAX_SIZE = 50000;
    private final int maxSize;
    private final WeakMap<Object, Object> map = WeakMap.Supplier.newWeakMap();

    public WeakMapContextStore(int maxSize) {
        this.maxSize = maxSize;
    }

    public WeakMapContextStore() {
        this(50000);
    }

    @Override
    public V get(K key) {
        return (V)this.map.get(key);
    }

    @Override
    public void put(K key, V context) {
        if (this.map.size() < this.maxSize) {
            this.map.put(key, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V context) {
        V existingContext = this.get(key);
        if (null == existingContext) {
            WeakMap<Object, Object> weakMap = this.map;
            synchronized (weakMap) {
                existingContext = this.get(key);
                if (null == existingContext) {
                    existingContext = context;
                    this.put(key, existingContext);
                }
            }
        }
        return existingContext;
    }

    @Override
    public V putIfAbsent(K key, ContextStore.Factory<V> contextFactory) {
        return this.computeIfAbsent(key, (ContextStore.KeyAwareFactory<? super K, V>)contextFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, ContextStore.KeyAwareFactory<? super K, V> contextFactory) {
        V existingContext = this.get(key);
        if (null == existingContext) {
            WeakMap<Object, Object> weakMap = this.map;
            synchronized (weakMap) {
                existingContext = this.get(key);
                if (null == existingContext) {
                    existingContext = contextFactory.create(key);
                    this.put(key, existingContext);
                }
            }
        }
        return existingContext;
    }

    @Override
    public V remove(K key) {
        return (V)this.map.remove(key);
    }

    int size() {
        return this.map.size();
    }
}

