/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api.telemetry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Endpoint {
    private boolean fist;
    private String type;
    private String method;
    private String path;
    private String operation;
    private List<String> requestBodyType;
    private List<String> responseBodyType;
    private List<Integer> responseCode;
    private List<String> authentication;
    private Map<String, String> metadata;

    public boolean isFirst() {
        return this.fist;
    }

    public Endpoint first(boolean first) {
        this.fist = first;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public Endpoint type(String type) {
        this.type = type;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public Endpoint method(String method) {
        this.method = method;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public Endpoint path(String path) {
        this.path = path;
        return this;
    }

    public String getOperation() {
        return this.operation;
    }

    public Endpoint operation(String operation) {
        this.operation = operation;
        return this;
    }

    public List<String> getRequestBodyType() {
        return this.requestBodyType;
    }

    public Endpoint requestBodyType(List<String> requestBodyType) {
        this.requestBodyType = requestBodyType;
        return this;
    }

    public List<String> getResponseBodyType() {
        return this.responseBodyType;
    }

    public Endpoint responseBodyType(List<String> responseBodyType) {
        this.responseBodyType = responseBodyType;
        return this;
    }

    public List<Integer> getResponseCode() {
        return this.responseCode;
    }

    public Endpoint responseCode(List<Integer> responseCode) {
        this.responseCode = responseCode;
        return this;
    }

    public List<String> getAuthentication() {
        return this.authentication;
    }

    public Endpoint authentication(List<String> authentication) {
        this.authentication = authentication;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Endpoint metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public static interface Method {
        public static final String CONNECT = "CONNECT";
        public static final String HEAD = "HEAD";
        public static final String GET = "GET";
        public static final String POST = "POST";
        public static final String PUT = "PUT";
        public static final String PATCH = "PATCH";
        public static final String OPTIONS = "OPTIONS";
        public static final String DELETE = "DELETE";
        public static final String TRACE = "TRACE";
        public static final String ALL = "*";
        public static final Set<String> METHODS = new HashSet<String>(Arrays.asList("CONNECT", "HEAD", "GET", "POST", "PUT", "PATCH", "OPTIONS", "DELETE", "TRACE"));

        public static <E extends Enum<E>, C extends Collection<E>> List<String> parseMethods(C methods) {
            if (methods == null || methods.isEmpty()) {
                return Collections.singletonList(ALL);
            }
            ArrayList<String> result = new ArrayList<String>(methods.size());
            for (Enum value : methods) {
                String methodName = value.name().toUpperCase();
                if (!METHODS.contains(value.name())) continue;
                result.add(methodName);
            }
            return result;
        }
    }

    public static interface Type {
        public static final String REST = "REST";
    }

    public static interface Operation {
        public static final String HTTP_REQUEST = "http.request";
    }
}

