/*
 * Decompiled with CFR 0.152.
 */
package datadog.context;

import datadog.context.Context;
import datadog.context.ContextBinder;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
final class WeakMapContextBinder
implements ContextBinder {
    private static final Map<Object, Context> TRACKED = Collections.synchronizedMap(new WeakHashMap());

    WeakMapContextBinder() {
    }

    @Override
    public Context from(Object carrier) {
        Objects.requireNonNull(carrier, "Context carrier cannot be null");
        Context bound = TRACKED.get(carrier);
        return null != bound ? bound : Context.root();
    }

    @Override
    public void attachTo(Object carrier, Context context) {
        Objects.requireNonNull(carrier, "Context carrier cannot be null");
        Objects.requireNonNull(context, "Context cannot be null. Use detachFrom() instead.");
        TRACKED.put(carrier, context);
    }

    @Override
    public Context detachFrom(Object carrier) {
        Objects.requireNonNull(carrier, "Context key cannot be null");
        Context previous = TRACKED.remove(carrier);
        return null != previous ? previous : Context.root();
    }
}

