/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonSerialize(using=QueryValueWidgetDefinitionTypeSerializer.class)
public class QueryValueWidgetDefinitionType {
    public static final QueryValueWidgetDefinitionType QUERY_VALUE = new QueryValueWidgetDefinitionType("query_value");
    private static final Set<String> allowedValues = new HashSet<String>(Arrays.asList("query_value"));
    private String value;

    public boolean isValid() {
        return allowedValues.contains(this.value);
    }

    QueryValueWidgetDefinitionType(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value.equals(((QueryValueWidgetDefinitionType)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static QueryValueWidgetDefinitionType fromValue(String value) {
        return new QueryValueWidgetDefinitionType(value);
    }

    public static class QueryValueWidgetDefinitionTypeSerializer
    extends StdSerializer<QueryValueWidgetDefinitionType> {
        public QueryValueWidgetDefinitionTypeSerializer(Class<QueryValueWidgetDefinitionType> t) {
            super(t);
        }

        public QueryValueWidgetDefinitionTypeSerializer() {
            this(null);
        }

        public void serialize(QueryValueWidgetDefinitionType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject((Object)value.value);
        }
    }
}

