/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SecurityMonitoringRuleSeverity;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"notifications", "status"})
public class CloudConfigurationRuleCaseCreate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_NOTIFICATIONS = "notifications";
    private List<String> notifications = null;
    public static final String JSON_PROPERTY_STATUS = "status";
    private SecurityMonitoringRuleSeverity status;

    public CloudConfigurationRuleCaseCreate() {
    }

    @JsonCreator
    public CloudConfigurationRuleCaseCreate(@JsonProperty(required=true, value="status") SecurityMonitoringRuleSeverity status) {
        this.status = status;
        this.unparsed |= !status.isValid();
    }

    public CloudConfigurationRuleCaseCreate notifications(List<String> notifications) {
        this.notifications = notifications;
        return this;
    }

    public CloudConfigurationRuleCaseCreate addNotificationsItem(String notificationsItem) {
        if (this.notifications == null) {
            this.notifications = new ArrayList<String>();
        }
        this.notifications.add(notificationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="notifications")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getNotifications() {
        return this.notifications;
    }

    public void setNotifications(List<String> notifications) {
        this.notifications = notifications;
    }

    public CloudConfigurationRuleCaseCreate status(SecurityMonitoringRuleSeverity status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityMonitoringRuleSeverity getStatus() {
        return this.status;
    }

    public void setStatus(SecurityMonitoringRuleSeverity status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudConfigurationRuleCaseCreate cloudConfigurationRuleCaseCreate = (CloudConfigurationRuleCaseCreate)o;
        return Objects.equals(this.notifications, cloudConfigurationRuleCaseCreate.notifications) && Objects.equals(this.status, cloudConfigurationRuleCaseCreate.status);
    }

    public int hashCode() {
        return Objects.hash(this.notifications, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CloudConfigurationRuleCaseCreate {\n");
        sb.append("    notifications: ").append(this.toIndentedString(this.notifications)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

