/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.TopologyQuery;
import com.datadog.api.client.v1.model.TopologyRequestType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"query", "request_type"})
public class TopologyRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_QUERY = "query";
    private TopologyQuery query;
    public static final String JSON_PROPERTY_REQUEST_TYPE = "request_type";
    private TopologyRequestType requestType;

    public TopologyRequest query(TopologyQuery query) {
        this.query = query;
        this.unparsed |= query.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TopologyQuery getQuery() {
        return this.query;
    }

    public void setQuery(TopologyQuery query) {
        this.query = query;
    }

    public TopologyRequest requestType(TopologyRequestType requestType) {
        this.requestType = requestType;
        this.unparsed |= !requestType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="request_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TopologyRequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(TopologyRequestType requestType) {
        if (!requestType.isValid()) {
            this.unparsed = true;
        }
        this.requestType = requestType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopologyRequest topologyRequest = (TopologyRequest)o;
        return Objects.equals(this.query, topologyRequest.query) && Objects.equals(this.requestType, topologyRequest.requestType);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.requestType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TopologyRequest {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString(this.requestType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

