/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.MonitorDeviceID;
import com.datadog.api.client.v1.model.MonitorFormulaAndFunctionQueryDefinition;
import com.datadog.api.client.v1.model.MonitorOptionsAggregation;
import com.datadog.api.client.v1.model.MonitorOptionsSchedulingOptions;
import com.datadog.api.client.v1.model.MonitorRenotifyStatusType;
import com.datadog.api.client.v1.model.MonitorThresholdWindowOptions;
import com.datadog.api.client.v1.model.MonitorThresholds;
import com.datadog.api.client.v1.model.OnMissingDataOption;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"aggregation", "device_ids", "enable_logs_sample", "enable_samples", "escalation_message", "evaluation_delay", "group_retention_duration", "groupby_simple_monitor", "include_tags", "locked", "min_failure_duration", "min_location_failed", "new_group_delay", "new_host_delay", "no_data_timeframe", "notify_audit", "notify_by", "notify_no_data", "on_missing_data", "renotify_interval", "renotify_occurrences", "renotify_statuses", "require_full_window", "scheduling_options", "silenced", "synthetics_check_id", "threshold_windows", "thresholds", "timeout_h", "variables"})
public class MonitorOptions {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGGREGATION = "aggregation";
    private MonitorOptionsAggregation aggregation;
    public static final String JSON_PROPERTY_DEVICE_IDS = "device_ids";
    private List<MonitorDeviceID> deviceIds = null;
    public static final String JSON_PROPERTY_ENABLE_LOGS_SAMPLE = "enable_logs_sample";
    private Boolean enableLogsSample;
    public static final String JSON_PROPERTY_ENABLE_SAMPLES = "enable_samples";
    private Boolean enableSamples;
    public static final String JSON_PROPERTY_ESCALATION_MESSAGE = "escalation_message";
    private String escalationMessage = "none";
    public static final String JSON_PROPERTY_EVALUATION_DELAY = "evaluation_delay";
    private JsonNullable<Long> evaluationDelay = JsonNullable.undefined();
    public static final String JSON_PROPERTY_GROUP_RETENTION_DURATION = "group_retention_duration";
    private String groupRetentionDuration;
    public static final String JSON_PROPERTY_GROUPBY_SIMPLE_MONITOR = "groupby_simple_monitor";
    private Boolean groupbySimpleMonitor;
    public static final String JSON_PROPERTY_INCLUDE_TAGS = "include_tags";
    private Boolean includeTags = true;
    public static final String JSON_PROPERTY_LOCKED = "locked";
    private Boolean locked;
    public static final String JSON_PROPERTY_MIN_FAILURE_DURATION = "min_failure_duration";
    private JsonNullable<Long> minFailureDuration = JsonNullable.of((Object)0L);
    public static final String JSON_PROPERTY_MIN_LOCATION_FAILED = "min_location_failed";
    private JsonNullable<Long> minLocationFailed = JsonNullable.of((Object)1L);
    public static final String JSON_PROPERTY_NEW_GROUP_DELAY = "new_group_delay";
    private JsonNullable<Long> newGroupDelay = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NEW_HOST_DELAY = "new_host_delay";
    private JsonNullable<Long> newHostDelay = JsonNullable.of((Object)300L);
    public static final String JSON_PROPERTY_NO_DATA_TIMEFRAME = "no_data_timeframe";
    private JsonNullable<Long> noDataTimeframe = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NOTIFY_AUDIT = "notify_audit";
    private Boolean notifyAudit = false;
    public static final String JSON_PROPERTY_NOTIFY_BY = "notify_by";
    private List<String> notifyBy = null;
    public static final String JSON_PROPERTY_NOTIFY_NO_DATA = "notify_no_data";
    private Boolean notifyNoData = false;
    public static final String JSON_PROPERTY_ON_MISSING_DATA = "on_missing_data";
    private OnMissingDataOption onMissingData;
    public static final String JSON_PROPERTY_RENOTIFY_INTERVAL = "renotify_interval";
    private JsonNullable<Long> renotifyInterval = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RENOTIFY_OCCURRENCES = "renotify_occurrences";
    private JsonNullable<Long> renotifyOccurrences = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RENOTIFY_STATUSES = "renotify_statuses";
    private JsonNullable<List<MonitorRenotifyStatusType>> renotifyStatuses = JsonNullable.undefined();
    public static final String JSON_PROPERTY_REQUIRE_FULL_WINDOW = "require_full_window";
    private Boolean requireFullWindow;
    public static final String JSON_PROPERTY_SCHEDULING_OPTIONS = "scheduling_options";
    private MonitorOptionsSchedulingOptions schedulingOptions;
    public static final String JSON_PROPERTY_SILENCED = "silenced";
    private Map<String, Long> silenced = null;
    public static final String JSON_PROPERTY_SYNTHETICS_CHECK_ID = "synthetics_check_id";
    private JsonNullable<String> syntheticsCheckId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_THRESHOLD_WINDOWS = "threshold_windows";
    private MonitorThresholdWindowOptions thresholdWindows;
    public static final String JSON_PROPERTY_THRESHOLDS = "thresholds";
    private MonitorThresholds thresholds;
    public static final String JSON_PROPERTY_TIMEOUT_H = "timeout_h";
    private JsonNullable<Long> timeoutH = JsonNullable.undefined();
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private List<MonitorFormulaAndFunctionQueryDefinition> variables = null;

    @Nullable
    @JsonProperty(value="aggregation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorOptionsAggregation getAggregation() {
        return this.aggregation;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="device_ids")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MonitorDeviceID> getDeviceIds() {
        return this.deviceIds;
    }

    @Deprecated
    public MonitorOptions enableLogsSample(Boolean enableLogsSample) {
        this.enableLogsSample = enableLogsSample;
        return this;
    }

    @Nullable
    @JsonProperty(value="enable_logs_sample")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnableLogsSample() {
        return this.enableLogsSample;
    }

    public void setEnableLogsSample(Boolean enableLogsSample) {
        this.enableLogsSample = enableLogsSample;
    }

    public MonitorOptions enableSamples(Boolean enableSamples) {
        this.enableSamples = enableSamples;
        return this;
    }

    @Nullable
    @JsonProperty(value="enable_samples")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getEnableSamples() {
        return this.enableSamples;
    }

    public void setEnableSamples(Boolean enableSamples) {
        this.enableSamples = enableSamples;
    }

    public MonitorOptions escalationMessage(String escalationMessage) {
        this.escalationMessage = escalationMessage;
        return this;
    }

    @Nullable
    @JsonProperty(value="escalation_message")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEscalationMessage() {
        return this.escalationMessage;
    }

    public void setEscalationMessage(String escalationMessage) {
        this.escalationMessage = escalationMessage;
    }

    public MonitorOptions evaluationDelay(Long evaluationDelay) {
        this.evaluationDelay = JsonNullable.of((Object)evaluationDelay);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getEvaluationDelay() {
        return (Long)this.evaluationDelay.orElse(null);
    }

    @JsonProperty(value="evaluation_delay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getEvaluationDelay_JsonNullable() {
        return this.evaluationDelay;
    }

    @JsonProperty(value="evaluation_delay")
    public void setEvaluationDelay_JsonNullable(JsonNullable<Long> evaluationDelay) {
        this.evaluationDelay = evaluationDelay;
    }

    public void setEvaluationDelay(Long evaluationDelay) {
        this.evaluationDelay = JsonNullable.of((Object)evaluationDelay);
    }

    public MonitorOptions groupRetentionDuration(String groupRetentionDuration) {
        this.groupRetentionDuration = groupRetentionDuration;
        return this;
    }

    @Nullable
    @JsonProperty(value="group_retention_duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGroupRetentionDuration() {
        return this.groupRetentionDuration;
    }

    public void setGroupRetentionDuration(String groupRetentionDuration) {
        this.groupRetentionDuration = groupRetentionDuration;
    }

    public MonitorOptions groupbySimpleMonitor(Boolean groupbySimpleMonitor) {
        this.groupbySimpleMonitor = groupbySimpleMonitor;
        return this;
    }

    @Nullable
    @JsonProperty(value="groupby_simple_monitor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getGroupbySimpleMonitor() {
        return this.groupbySimpleMonitor;
    }

    public void setGroupbySimpleMonitor(Boolean groupbySimpleMonitor) {
        this.groupbySimpleMonitor = groupbySimpleMonitor;
    }

    public MonitorOptions includeTags(Boolean includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    @Nullable
    @JsonProperty(value="include_tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIncludeTags() {
        return this.includeTags;
    }

    public void setIncludeTags(Boolean includeTags) {
        this.includeTags = includeTags;
    }

    public MonitorOptions locked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getLocked() {
        return this.locked;
    }

    @Deprecated
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public MonitorOptions minFailureDuration(Long minFailureDuration) {
        this.minFailureDuration = JsonNullable.of((Object)minFailureDuration);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getMinFailureDuration() {
        return (Long)this.minFailureDuration.orElse(null);
    }

    @JsonProperty(value="min_failure_duration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getMinFailureDuration_JsonNullable() {
        return this.minFailureDuration;
    }

    @JsonProperty(value="min_failure_duration")
    public void setMinFailureDuration_JsonNullable(JsonNullable<Long> minFailureDuration) {
        this.minFailureDuration = minFailureDuration;
    }

    public void setMinFailureDuration(Long minFailureDuration) {
        this.minFailureDuration = JsonNullable.of((Object)minFailureDuration);
    }

    public MonitorOptions minLocationFailed(Long minLocationFailed) {
        this.minLocationFailed = JsonNullable.of((Object)minLocationFailed);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getMinLocationFailed() {
        return (Long)this.minLocationFailed.orElse(null);
    }

    @JsonProperty(value="min_location_failed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getMinLocationFailed_JsonNullable() {
        return this.minLocationFailed;
    }

    @JsonProperty(value="min_location_failed")
    public void setMinLocationFailed_JsonNullable(JsonNullable<Long> minLocationFailed) {
        this.minLocationFailed = minLocationFailed;
    }

    public void setMinLocationFailed(Long minLocationFailed) {
        this.minLocationFailed = JsonNullable.of((Object)minLocationFailed);
    }

    public MonitorOptions newGroupDelay(Long newGroupDelay) {
        this.newGroupDelay = JsonNullable.of((Object)newGroupDelay);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getNewGroupDelay() {
        return (Long)this.newGroupDelay.orElse(null);
    }

    @JsonProperty(value="new_group_delay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getNewGroupDelay_JsonNullable() {
        return this.newGroupDelay;
    }

    @JsonProperty(value="new_group_delay")
    public void setNewGroupDelay_JsonNullable(JsonNullable<Long> newGroupDelay) {
        this.newGroupDelay = newGroupDelay;
    }

    public void setNewGroupDelay(Long newGroupDelay) {
        this.newGroupDelay = JsonNullable.of((Object)newGroupDelay);
    }

    public MonitorOptions newHostDelay(Long newHostDelay) {
        this.newHostDelay = JsonNullable.of((Object)newHostDelay);
        return this;
    }

    @Deprecated
    @Nullable
    @JsonIgnore
    public Long getNewHostDelay() {
        return (Long)this.newHostDelay.orElse(null);
    }

    @Deprecated
    @JsonProperty(value="new_host_delay")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getNewHostDelay_JsonNullable() {
        return this.newHostDelay;
    }

    @JsonProperty(value="new_host_delay")
    public void setNewHostDelay_JsonNullable(JsonNullable<Long> newHostDelay) {
        this.newHostDelay = newHostDelay;
    }

    public void setNewHostDelay(Long newHostDelay) {
        this.newHostDelay = JsonNullable.of((Object)newHostDelay);
    }

    public MonitorOptions noDataTimeframe(Long noDataTimeframe) {
        this.noDataTimeframe = JsonNullable.of((Object)noDataTimeframe);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getNoDataTimeframe() {
        return (Long)this.noDataTimeframe.orElse(null);
    }

    @JsonProperty(value="no_data_timeframe")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getNoDataTimeframe_JsonNullable() {
        return this.noDataTimeframe;
    }

    @JsonProperty(value="no_data_timeframe")
    public void setNoDataTimeframe_JsonNullable(JsonNullable<Long> noDataTimeframe) {
        this.noDataTimeframe = noDataTimeframe;
    }

    public void setNoDataTimeframe(Long noDataTimeframe) {
        this.noDataTimeframe = JsonNullable.of((Object)noDataTimeframe);
    }

    public MonitorOptions notifyAudit(Boolean notifyAudit) {
        this.notifyAudit = notifyAudit;
        return this;
    }

    @Nullable
    @JsonProperty(value="notify_audit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNotifyAudit() {
        return this.notifyAudit;
    }

    public void setNotifyAudit(Boolean notifyAudit) {
        this.notifyAudit = notifyAudit;
    }

    public MonitorOptions notifyBy(List<String> notifyBy) {
        this.notifyBy = notifyBy;
        return this;
    }

    public MonitorOptions addNotifyByItem(String notifyByItem) {
        if (this.notifyBy == null) {
            this.notifyBy = new ArrayList<String>();
        }
        this.notifyBy.add(notifyByItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="notify_by")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getNotifyBy() {
        return this.notifyBy;
    }

    public void setNotifyBy(List<String> notifyBy) {
        this.notifyBy = notifyBy;
    }

    public MonitorOptions notifyNoData(Boolean notifyNoData) {
        this.notifyNoData = notifyNoData;
        return this;
    }

    @Nullable
    @JsonProperty(value="notify_no_data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNotifyNoData() {
        return this.notifyNoData;
    }

    public void setNotifyNoData(Boolean notifyNoData) {
        this.notifyNoData = notifyNoData;
    }

    public MonitorOptions onMissingData(OnMissingDataOption onMissingData) {
        this.onMissingData = onMissingData;
        this.unparsed |= !onMissingData.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="on_missing_data")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OnMissingDataOption getOnMissingData() {
        return this.onMissingData;
    }

    public void setOnMissingData(OnMissingDataOption onMissingData) {
        if (!onMissingData.isValid()) {
            this.unparsed = true;
        }
        this.onMissingData = onMissingData;
    }

    public MonitorOptions renotifyInterval(Long renotifyInterval) {
        this.renotifyInterval = JsonNullable.of((Object)renotifyInterval);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getRenotifyInterval() {
        return (Long)this.renotifyInterval.orElse(null);
    }

    @JsonProperty(value="renotify_interval")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getRenotifyInterval_JsonNullable() {
        return this.renotifyInterval;
    }

    @JsonProperty(value="renotify_interval")
    public void setRenotifyInterval_JsonNullable(JsonNullable<Long> renotifyInterval) {
        this.renotifyInterval = renotifyInterval;
    }

    public void setRenotifyInterval(Long renotifyInterval) {
        this.renotifyInterval = JsonNullable.of((Object)renotifyInterval);
    }

    public MonitorOptions renotifyOccurrences(Long renotifyOccurrences) {
        this.renotifyOccurrences = JsonNullable.of((Object)renotifyOccurrences);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getRenotifyOccurrences() {
        return (Long)this.renotifyOccurrences.orElse(null);
    }

    @JsonProperty(value="renotify_occurrences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getRenotifyOccurrences_JsonNullable() {
        return this.renotifyOccurrences;
    }

    @JsonProperty(value="renotify_occurrences")
    public void setRenotifyOccurrences_JsonNullable(JsonNullable<Long> renotifyOccurrences) {
        this.renotifyOccurrences = renotifyOccurrences;
    }

    public void setRenotifyOccurrences(Long renotifyOccurrences) {
        this.renotifyOccurrences = JsonNullable.of((Object)renotifyOccurrences);
    }

    public MonitorOptions renotifyStatuses(List<MonitorRenotifyStatusType> renotifyStatuses) {
        this.renotifyStatuses = JsonNullable.of(renotifyStatuses);
        return this;
    }

    public MonitorOptions addRenotifyStatusesItem(MonitorRenotifyStatusType renotifyStatusesItem) {
        if (this.renotifyStatuses == null || !this.renotifyStatuses.isPresent()) {
            this.renotifyStatuses = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.renotifyStatuses.get()).add(renotifyStatusesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<MonitorRenotifyStatusType> getRenotifyStatuses() {
        return (List)this.renotifyStatuses.orElse(null);
    }

    @JsonProperty(value="renotify_statuses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<MonitorRenotifyStatusType>> getRenotifyStatuses_JsonNullable() {
        return this.renotifyStatuses;
    }

    @JsonProperty(value="renotify_statuses")
    public void setRenotifyStatuses_JsonNullable(JsonNullable<List<MonitorRenotifyStatusType>> renotifyStatuses) {
        this.renotifyStatuses = renotifyStatuses;
    }

    public void setRenotifyStatuses(List<MonitorRenotifyStatusType> renotifyStatuses) {
        this.renotifyStatuses = JsonNullable.of(renotifyStatuses);
    }

    public MonitorOptions requireFullWindow(Boolean requireFullWindow) {
        this.requireFullWindow = requireFullWindow;
        return this;
    }

    @Nullable
    @JsonProperty(value="require_full_window")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequireFullWindow() {
        return this.requireFullWindow;
    }

    public void setRequireFullWindow(Boolean requireFullWindow) {
        this.requireFullWindow = requireFullWindow;
    }

    public MonitorOptions schedulingOptions(MonitorOptionsSchedulingOptions schedulingOptions) {
        this.schedulingOptions = schedulingOptions;
        this.unparsed |= schedulingOptions.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="scheduling_options")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorOptionsSchedulingOptions getSchedulingOptions() {
        return this.schedulingOptions;
    }

    public void setSchedulingOptions(MonitorOptionsSchedulingOptions schedulingOptions) {
        this.schedulingOptions = schedulingOptions;
    }

    public MonitorOptions silenced(Map<String, Long> silenced) {
        this.silenced = silenced;
        return this;
    }

    public MonitorOptions putSilencedItem(String key, Long silencedItem) {
        if (this.silenced == null) {
            this.silenced = new HashMap<String, Long>();
        }
        this.silenced.put(key, silencedItem);
        return this;
    }

    @Deprecated
    @Nullable
    @JsonProperty(value="silenced")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Long> getSilenced() {
        return this.silenced;
    }

    @Deprecated
    public void setSilenced(Map<String, Long> silenced) {
        this.silenced = silenced;
    }

    public MonitorOptions syntheticsCheckId(String syntheticsCheckId) {
        this.syntheticsCheckId = JsonNullable.of((Object)syntheticsCheckId);
        return this;
    }

    @Deprecated
    @Nullable
    @JsonIgnore
    public String getSyntheticsCheckId() {
        return (String)this.syntheticsCheckId.orElse(null);
    }

    @Deprecated
    @JsonProperty(value="synthetics_check_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSyntheticsCheckId_JsonNullable() {
        return this.syntheticsCheckId;
    }

    @JsonProperty(value="synthetics_check_id")
    public void setSyntheticsCheckId_JsonNullable(JsonNullable<String> syntheticsCheckId) {
        this.syntheticsCheckId = syntheticsCheckId;
    }

    public void setSyntheticsCheckId(String syntheticsCheckId) {
        this.syntheticsCheckId = JsonNullable.of((Object)syntheticsCheckId);
    }

    public MonitorOptions thresholdWindows(MonitorThresholdWindowOptions thresholdWindows) {
        this.thresholdWindows = thresholdWindows;
        this.unparsed |= thresholdWindows.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="threshold_windows")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorThresholdWindowOptions getThresholdWindows() {
        return this.thresholdWindows;
    }

    public void setThresholdWindows(MonitorThresholdWindowOptions thresholdWindows) {
        this.thresholdWindows = thresholdWindows;
    }

    public MonitorOptions thresholds(MonitorThresholds thresholds) {
        this.thresholds = thresholds;
        this.unparsed |= thresholds.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="thresholds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MonitorThresholds getThresholds() {
        return this.thresholds;
    }

    public void setThresholds(MonitorThresholds thresholds) {
        this.thresholds = thresholds;
    }

    public MonitorOptions timeoutH(Long timeoutH) {
        this.timeoutH = JsonNullable.of((Object)timeoutH);
        return this;
    }

    @Nullable
    @JsonIgnore
    public Long getTimeoutH() {
        return (Long)this.timeoutH.orElse(null);
    }

    @JsonProperty(value="timeout_h")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Long> getTimeoutH_JsonNullable() {
        return this.timeoutH;
    }

    @JsonProperty(value="timeout_h")
    public void setTimeoutH_JsonNullable(JsonNullable<Long> timeoutH) {
        this.timeoutH = timeoutH;
    }

    public void setTimeoutH(Long timeoutH) {
        this.timeoutH = JsonNullable.of((Object)timeoutH);
    }

    public MonitorOptions variables(List<MonitorFormulaAndFunctionQueryDefinition> variables) {
        this.variables = variables;
        for (MonitorFormulaAndFunctionQueryDefinition item : variables) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public MonitorOptions addVariablesItem(MonitorFormulaAndFunctionQueryDefinition variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<MonitorFormulaAndFunctionQueryDefinition>();
        }
        this.variables.add(variablesItem);
        this.unparsed |= variablesItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MonitorFormulaAndFunctionQueryDefinition> getVariables() {
        return this.variables;
    }

    public void setVariables(List<MonitorFormulaAndFunctionQueryDefinition> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorOptions monitorOptions = (MonitorOptions)o;
        return Objects.equals(this.aggregation, monitorOptions.aggregation) && Objects.equals(this.deviceIds, monitorOptions.deviceIds) && Objects.equals(this.enableLogsSample, monitorOptions.enableLogsSample) && Objects.equals(this.enableSamples, monitorOptions.enableSamples) && Objects.equals(this.escalationMessage, monitorOptions.escalationMessage) && Objects.equals(this.evaluationDelay, monitorOptions.evaluationDelay) && Objects.equals(this.groupRetentionDuration, monitorOptions.groupRetentionDuration) && Objects.equals(this.groupbySimpleMonitor, monitorOptions.groupbySimpleMonitor) && Objects.equals(this.includeTags, monitorOptions.includeTags) && Objects.equals(this.locked, monitorOptions.locked) && Objects.equals(this.minFailureDuration, monitorOptions.minFailureDuration) && Objects.equals(this.minLocationFailed, monitorOptions.minLocationFailed) && Objects.equals(this.newGroupDelay, monitorOptions.newGroupDelay) && Objects.equals(this.newHostDelay, monitorOptions.newHostDelay) && Objects.equals(this.noDataTimeframe, monitorOptions.noDataTimeframe) && Objects.equals(this.notifyAudit, monitorOptions.notifyAudit) && Objects.equals(this.notifyBy, monitorOptions.notifyBy) && Objects.equals(this.notifyNoData, monitorOptions.notifyNoData) && Objects.equals(this.onMissingData, monitorOptions.onMissingData) && Objects.equals(this.renotifyInterval, monitorOptions.renotifyInterval) && Objects.equals(this.renotifyOccurrences, monitorOptions.renotifyOccurrences) && Objects.equals(this.renotifyStatuses, monitorOptions.renotifyStatuses) && Objects.equals(this.requireFullWindow, monitorOptions.requireFullWindow) && Objects.equals(this.schedulingOptions, monitorOptions.schedulingOptions) && Objects.equals(this.silenced, monitorOptions.silenced) && Objects.equals(this.syntheticsCheckId, monitorOptions.syntheticsCheckId) && Objects.equals(this.thresholdWindows, monitorOptions.thresholdWindows) && Objects.equals(this.thresholds, monitorOptions.thresholds) && Objects.equals(this.timeoutH, monitorOptions.timeoutH) && Objects.equals(this.variables, monitorOptions.variables);
    }

    public int hashCode() {
        return Objects.hash(this.aggregation, this.deviceIds, this.enableLogsSample, this.enableSamples, this.escalationMessage, this.evaluationDelay, this.groupRetentionDuration, this.groupbySimpleMonitor, this.includeTags, this.locked, this.minFailureDuration, this.minLocationFailed, this.newGroupDelay, this.newHostDelay, this.noDataTimeframe, this.notifyAudit, this.notifyBy, this.notifyNoData, this.onMissingData, this.renotifyInterval, this.renotifyOccurrences, this.renotifyStatuses, this.requireFullWindow, this.schedulingOptions, this.silenced, this.syntheticsCheckId, this.thresholdWindows, this.thresholds, this.timeoutH, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MonitorOptions {\n");
        sb.append("    aggregation: ").append(this.toIndentedString(this.aggregation)).append("\n");
        sb.append("    deviceIds: ").append(this.toIndentedString(this.deviceIds)).append("\n");
        sb.append("    enableLogsSample: ").append(this.toIndentedString(this.enableLogsSample)).append("\n");
        sb.append("    enableSamples: ").append(this.toIndentedString(this.enableSamples)).append("\n");
        sb.append("    escalationMessage: ").append(this.toIndentedString(this.escalationMessage)).append("\n");
        sb.append("    evaluationDelay: ").append(this.toIndentedString(this.evaluationDelay)).append("\n");
        sb.append("    groupRetentionDuration: ").append(this.toIndentedString(this.groupRetentionDuration)).append("\n");
        sb.append("    groupbySimpleMonitor: ").append(this.toIndentedString(this.groupbySimpleMonitor)).append("\n");
        sb.append("    includeTags: ").append(this.toIndentedString(this.includeTags)).append("\n");
        sb.append("    locked: ").append(this.toIndentedString(this.locked)).append("\n");
        sb.append("    minFailureDuration: ").append(this.toIndentedString(this.minFailureDuration)).append("\n");
        sb.append("    minLocationFailed: ").append(this.toIndentedString(this.minLocationFailed)).append("\n");
        sb.append("    newGroupDelay: ").append(this.toIndentedString(this.newGroupDelay)).append("\n");
        sb.append("    newHostDelay: ").append(this.toIndentedString(this.newHostDelay)).append("\n");
        sb.append("    noDataTimeframe: ").append(this.toIndentedString(this.noDataTimeframe)).append("\n");
        sb.append("    notifyAudit: ").append(this.toIndentedString(this.notifyAudit)).append("\n");
        sb.append("    notifyBy: ").append(this.toIndentedString(this.notifyBy)).append("\n");
        sb.append("    notifyNoData: ").append(this.toIndentedString(this.notifyNoData)).append("\n");
        sb.append("    onMissingData: ").append(this.toIndentedString(this.onMissingData)).append("\n");
        sb.append("    renotifyInterval: ").append(this.toIndentedString(this.renotifyInterval)).append("\n");
        sb.append("    renotifyOccurrences: ").append(this.toIndentedString(this.renotifyOccurrences)).append("\n");
        sb.append("    renotifyStatuses: ").append(this.toIndentedString(this.renotifyStatuses)).append("\n");
        sb.append("    requireFullWindow: ").append(this.toIndentedString(this.requireFullWindow)).append("\n");
        sb.append("    schedulingOptions: ").append(this.toIndentedString(this.schedulingOptions)).append("\n");
        sb.append("    silenced: ").append(this.toIndentedString(this.silenced)).append("\n");
        sb.append("    syntheticsCheckId: ").append(this.toIndentedString(this.syntheticsCheckId)).append("\n");
        sb.append("    thresholdWindows: ").append(this.toIndentedString(this.thresholdWindows)).append("\n");
        sb.append("    thresholds: ").append(this.toIndentedString(this.thresholds)).append("\n");
        sb.append("    timeoutH: ").append(this.toIndentedString(this.timeoutH)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

