/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.LogsExclusion;
import com.datadog.api.client.v1.model.LogsFilter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"daily_limit", "disable_daily_limit", "exclusion_filters", "filter", "num_retention_days"})
public class LogsIndexUpdateRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DAILY_LIMIT = "daily_limit";
    private Long dailyLimit;
    public static final String JSON_PROPERTY_DISABLE_DAILY_LIMIT = "disable_daily_limit";
    private Boolean disableDailyLimit;
    public static final String JSON_PROPERTY_EXCLUSION_FILTERS = "exclusion_filters";
    private List<LogsExclusion> exclusionFilters = null;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private LogsFilter filter;
    public static final String JSON_PROPERTY_NUM_RETENTION_DAYS = "num_retention_days";
    private Long numRetentionDays;

    public LogsIndexUpdateRequest() {
    }

    @JsonCreator
    public LogsIndexUpdateRequest(@JsonProperty(required=true, value="filter") LogsFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
    }

    public LogsIndexUpdateRequest dailyLimit(Long dailyLimit) {
        this.dailyLimit = dailyLimit;
        return this;
    }

    @Nullable
    @JsonProperty(value="daily_limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDailyLimit() {
        return this.dailyLimit;
    }

    public void setDailyLimit(Long dailyLimit) {
        this.dailyLimit = dailyLimit;
    }

    public LogsIndexUpdateRequest disableDailyLimit(Boolean disableDailyLimit) {
        this.disableDailyLimit = disableDailyLimit;
        return this;
    }

    @Nullable
    @JsonProperty(value="disable_daily_limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDisableDailyLimit() {
        return this.disableDailyLimit;
    }

    public void setDisableDailyLimit(Boolean disableDailyLimit) {
        this.disableDailyLimit = disableDailyLimit;
    }

    public LogsIndexUpdateRequest exclusionFilters(List<LogsExclusion> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
        for (LogsExclusion item : exclusionFilters) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public LogsIndexUpdateRequest addExclusionFiltersItem(LogsExclusion exclusionFiltersItem) {
        if (this.exclusionFilters == null) {
            this.exclusionFilters = new ArrayList<LogsExclusion>();
        }
        this.exclusionFilters.add(exclusionFiltersItem);
        this.unparsed |= exclusionFiltersItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="exclusion_filters")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<LogsExclusion> getExclusionFilters() {
        return this.exclusionFilters;
    }

    public void setExclusionFilters(List<LogsExclusion> exclusionFilters) {
        this.exclusionFilters = exclusionFilters;
    }

    public LogsIndexUpdateRequest filter(LogsFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LogsFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LogsFilter filter) {
        this.filter = filter;
    }

    public LogsIndexUpdateRequest numRetentionDays(Long numRetentionDays) {
        this.numRetentionDays = numRetentionDays;
        return this;
    }

    @Nullable
    @JsonProperty(value="num_retention_days")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getNumRetentionDays() {
        return this.numRetentionDays;
    }

    public void setNumRetentionDays(Long numRetentionDays) {
        this.numRetentionDays = numRetentionDays;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogsIndexUpdateRequest logsIndexUpdateRequest = (LogsIndexUpdateRequest)o;
        return Objects.equals(this.dailyLimit, logsIndexUpdateRequest.dailyLimit) && Objects.equals(this.disableDailyLimit, logsIndexUpdateRequest.disableDailyLimit) && Objects.equals(this.exclusionFilters, logsIndexUpdateRequest.exclusionFilters) && Objects.equals(this.filter, logsIndexUpdateRequest.filter) && Objects.equals(this.numRetentionDays, logsIndexUpdateRequest.numRetentionDays);
    }

    public int hashCode() {
        return Objects.hash(this.dailyLimit, this.disableDailyLimit, this.exclusionFilters, this.filter, this.numRetentionDays);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LogsIndexUpdateRequest {\n");
        sb.append("    dailyLimit: ").append(this.toIndentedString(this.dailyLimit)).append("\n");
        sb.append("    disableDailyLimit: ").append(this.toIndentedString(this.disableDailyLimit)).append("\n");
        sb.append("    exclusionFilters: ").append(this.toIndentedString(this.exclusionFilters)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    numRetentionDays: ").append(this.toIndentedString(this.numRetentionDays)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

