/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v1.model;

import com.datadog.api.client.v1.model.ApmStatsQueryDefinition;
import com.datadog.api.client.v1.model.DistributionWidgetHistogramRequestQuery;
import com.datadog.api.client.v1.model.DistributionWidgetHistogramRequestType;
import com.datadog.api.client.v1.model.LogQueryDefinition;
import com.datadog.api.client.v1.model.ProcessQueryDefinition;
import com.datadog.api.client.v1.model.WidgetStyle;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Objects;

@JsonPropertyOrder(value={"apm_query", "apm_stats_query", "event_query", "log_query", "network_query", "process_query", "profile_metrics_query", "q", "query", "request_type", "rum_query", "security_query", "style"})
public class DistributionWidgetRequest {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_APM_QUERY = "apm_query";
    private LogQueryDefinition apmQuery;
    public static final String JSON_PROPERTY_APM_STATS_QUERY = "apm_stats_query";
    private ApmStatsQueryDefinition apmStatsQuery;
    public static final String JSON_PROPERTY_EVENT_QUERY = "event_query";
    private LogQueryDefinition eventQuery;
    public static final String JSON_PROPERTY_LOG_QUERY = "log_query";
    private LogQueryDefinition logQuery;
    public static final String JSON_PROPERTY_NETWORK_QUERY = "network_query";
    private LogQueryDefinition networkQuery;
    public static final String JSON_PROPERTY_PROCESS_QUERY = "process_query";
    private ProcessQueryDefinition processQuery;
    public static final String JSON_PROPERTY_PROFILE_METRICS_QUERY = "profile_metrics_query";
    private LogQueryDefinition profileMetricsQuery;
    public static final String JSON_PROPERTY_Q = "q";
    private String q;
    public static final String JSON_PROPERTY_QUERY = "query";
    private DistributionWidgetHistogramRequestQuery query;
    public static final String JSON_PROPERTY_REQUEST_TYPE = "request_type";
    private DistributionWidgetHistogramRequestType requestType;
    public static final String JSON_PROPERTY_RUM_QUERY = "rum_query";
    private LogQueryDefinition rumQuery;
    public static final String JSON_PROPERTY_SECURITY_QUERY = "security_query";
    private LogQueryDefinition securityQuery;
    public static final String JSON_PROPERTY_STYLE = "style";
    private WidgetStyle style;

    public DistributionWidgetRequest apmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
        this.unparsed |= apmQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="apm_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getApmQuery() {
        return this.apmQuery;
    }

    public void setApmQuery(LogQueryDefinition apmQuery) {
        this.apmQuery = apmQuery;
    }

    public DistributionWidgetRequest apmStatsQuery(ApmStatsQueryDefinition apmStatsQuery) {
        this.apmStatsQuery = apmStatsQuery;
        this.unparsed |= apmStatsQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="apm_stats_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApmStatsQueryDefinition getApmStatsQuery() {
        return this.apmStatsQuery;
    }

    public void setApmStatsQuery(ApmStatsQueryDefinition apmStatsQuery) {
        this.apmStatsQuery = apmStatsQuery;
    }

    public DistributionWidgetRequest eventQuery(LogQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
        this.unparsed |= eventQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="event_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getEventQuery() {
        return this.eventQuery;
    }

    public void setEventQuery(LogQueryDefinition eventQuery) {
        this.eventQuery = eventQuery;
    }

    public DistributionWidgetRequest logQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
        this.unparsed |= logQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="log_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getLogQuery() {
        return this.logQuery;
    }

    public void setLogQuery(LogQueryDefinition logQuery) {
        this.logQuery = logQuery;
    }

    public DistributionWidgetRequest networkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
        this.unparsed |= networkQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="network_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getNetworkQuery() {
        return this.networkQuery;
    }

    public void setNetworkQuery(LogQueryDefinition networkQuery) {
        this.networkQuery = networkQuery;
    }

    public DistributionWidgetRequest processQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
        this.unparsed |= processQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="process_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ProcessQueryDefinition getProcessQuery() {
        return this.processQuery;
    }

    public void setProcessQuery(ProcessQueryDefinition processQuery) {
        this.processQuery = processQuery;
    }

    public DistributionWidgetRequest profileMetricsQuery(LogQueryDefinition profileMetricsQuery) {
        this.profileMetricsQuery = profileMetricsQuery;
        this.unparsed |= profileMetricsQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="profile_metrics_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getProfileMetricsQuery() {
        return this.profileMetricsQuery;
    }

    public void setProfileMetricsQuery(LogQueryDefinition profileMetricsQuery) {
        this.profileMetricsQuery = profileMetricsQuery;
    }

    public DistributionWidgetRequest q(String q) {
        this.q = q;
        return this;
    }

    @Nullable
    @JsonProperty(value="q")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public DistributionWidgetRequest query(DistributionWidgetHistogramRequestQuery query) {
        this.query = query;
        this.unparsed |= query.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DistributionWidgetHistogramRequestQuery getQuery() {
        return this.query;
    }

    public void setQuery(DistributionWidgetHistogramRequestQuery query) {
        this.query = query;
    }

    public DistributionWidgetRequest requestType(DistributionWidgetHistogramRequestType requestType) {
        this.requestType = requestType;
        this.unparsed |= !requestType.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="request_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DistributionWidgetHistogramRequestType getRequestType() {
        return this.requestType;
    }

    public void setRequestType(DistributionWidgetHistogramRequestType requestType) {
        if (!requestType.isValid()) {
            this.unparsed = true;
        }
        this.requestType = requestType;
    }

    public DistributionWidgetRequest rumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
        this.unparsed |= rumQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="rum_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getRumQuery() {
        return this.rumQuery;
    }

    public void setRumQuery(LogQueryDefinition rumQuery) {
        this.rumQuery = rumQuery;
    }

    public DistributionWidgetRequest securityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
        this.unparsed |= securityQuery.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="security_query")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LogQueryDefinition getSecurityQuery() {
        return this.securityQuery;
    }

    public void setSecurityQuery(LogQueryDefinition securityQuery) {
        this.securityQuery = securityQuery;
    }

    public DistributionWidgetRequest style(WidgetStyle style) {
        this.style = style;
        this.unparsed |= style.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="style")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public WidgetStyle getStyle() {
        return this.style;
    }

    public void setStyle(WidgetStyle style) {
        this.style = style;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributionWidgetRequest distributionWidgetRequest = (DistributionWidgetRequest)o;
        return Objects.equals(this.apmQuery, distributionWidgetRequest.apmQuery) && Objects.equals(this.apmStatsQuery, distributionWidgetRequest.apmStatsQuery) && Objects.equals(this.eventQuery, distributionWidgetRequest.eventQuery) && Objects.equals(this.logQuery, distributionWidgetRequest.logQuery) && Objects.equals(this.networkQuery, distributionWidgetRequest.networkQuery) && Objects.equals(this.processQuery, distributionWidgetRequest.processQuery) && Objects.equals(this.profileMetricsQuery, distributionWidgetRequest.profileMetricsQuery) && Objects.equals(this.q, distributionWidgetRequest.q) && Objects.equals(this.query, distributionWidgetRequest.query) && Objects.equals(this.requestType, distributionWidgetRequest.requestType) && Objects.equals(this.rumQuery, distributionWidgetRequest.rumQuery) && Objects.equals(this.securityQuery, distributionWidgetRequest.securityQuery) && Objects.equals(this.style, distributionWidgetRequest.style);
    }

    public int hashCode() {
        return Objects.hash(this.apmQuery, this.apmStatsQuery, this.eventQuery, this.logQuery, this.networkQuery, this.processQuery, this.profileMetricsQuery, this.q, this.query, this.requestType, this.rumQuery, this.securityQuery, this.style);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DistributionWidgetRequest {\n");
        sb.append("    apmQuery: ").append(this.toIndentedString(this.apmQuery)).append("\n");
        sb.append("    apmStatsQuery: ").append(this.toIndentedString(this.apmStatsQuery)).append("\n");
        sb.append("    eventQuery: ").append(this.toIndentedString(this.eventQuery)).append("\n");
        sb.append("    logQuery: ").append(this.toIndentedString(this.logQuery)).append("\n");
        sb.append("    networkQuery: ").append(this.toIndentedString(this.networkQuery)).append("\n");
        sb.append("    processQuery: ").append(this.toIndentedString(this.processQuery)).append("\n");
        sb.append("    profileMetricsQuery: ").append(this.toIndentedString(this.profileMetricsQuery)).append("\n");
        sb.append("    q: ").append(this.toIndentedString(this.q)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    requestType: ").append(this.toIndentedString(this.requestType)).append("\n");
        sb.append("    rumQuery: ").append(this.toIndentedString(this.rumQuery)).append("\n");
        sb.append("    securityQuery: ").append(this.toIndentedString(this.securityQuery)).append("\n");
        sb.append("    style: ").append(this.toIndentedString(this.style)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

