/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.TimelineCellAuthor;
import com.datadog.api.client.v2.model.TimelineCellContent;
import com.datadog.api.client.v2.model.TimelineCellType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"author", "cell_content", "created_at", "deleted_at", "modified_at", "type"})
public class TimelineCell {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AUTHOR = "author";
    private TimelineCellAuthor author;
    public static final String JSON_PROPERTY_CELL_CONTENT = "cell_content";
    private TimelineCellContent cellContent;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DELETED_AT = "deleted_at";
    private OffsetDateTime deletedAt;
    public static final String JSON_PROPERTY_MODIFIED_AT = "modified_at";
    private OffsetDateTime modifiedAt;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TimelineCellType type;
    private Map<String, Object> additionalProperties;

    public TimelineCell author(TimelineCellAuthor author) {
        this.author = author;
        this.unparsed |= author.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="author")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TimelineCellAuthor getAuthor() {
        return this.author;
    }

    public void setAuthor(TimelineCellAuthor author) {
        this.author = author;
    }

    public TimelineCell cellContent(TimelineCellContent cellContent) {
        this.cellContent = cellContent;
        this.unparsed |= cellContent.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="cell_content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TimelineCellContent getCellContent() {
        return this.cellContent;
    }

    public void setCellContent(TimelineCellContent cellContent) {
        this.cellContent = cellContent;
    }

    @Nullable
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    @JsonProperty(value="deleted_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getDeletedAt() {
        return this.deletedAt;
    }

    @Nullable
    @JsonProperty(value="modified_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public TimelineCell type(TimelineCellType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TimelineCellType getType() {
        return this.type;
    }

    public void setType(TimelineCellType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public TimelineCell putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimelineCell timelineCell = (TimelineCell)o;
        return Objects.equals(this.author, timelineCell.author) && Objects.equals(this.cellContent, timelineCell.cellContent) && Objects.equals(this.createdAt, timelineCell.createdAt) && Objects.equals(this.deletedAt, timelineCell.deletedAt) && Objects.equals(this.modifiedAt, timelineCell.modifiedAt) && Objects.equals(this.type, timelineCell.type) && Objects.equals(this.additionalProperties, timelineCell.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.cellContent, this.createdAt, this.deletedAt, this.modifiedAt, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TimelineCell {\n");
        sb.append("    author: ").append(this.toIndentedString(this.author)).append("\n");
        sb.append("    cellContent: ").append(this.toIndentedString(this.cellContent)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    deletedAt: ").append(this.toIndentedString(this.deletedAt)).append("\n");
        sb.append("    modifiedAt: ").append(this.toIndentedString(this.modifiedAt)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

