/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ServiceNowBasicAuthType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"instance", "password", "type", "username"})
public class ServiceNowBasicAuthUpdate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_INSTANCE = "instance";
    private String instance;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ServiceNowBasicAuthType type;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;
    private Map<String, Object> additionalProperties;

    public ServiceNowBasicAuthUpdate() {
    }

    @JsonCreator
    public ServiceNowBasicAuthUpdate(@JsonProperty(required=true, value="type") ServiceNowBasicAuthType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public ServiceNowBasicAuthUpdate instance(String instance) {
        this.instance = instance;
        return this;
    }

    @Nullable
    @JsonProperty(value="instance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public ServiceNowBasicAuthUpdate password(String password) {
        this.password = password;
        return this;
    }

    @Nullable
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ServiceNowBasicAuthUpdate type(ServiceNowBasicAuthType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ServiceNowBasicAuthType getType() {
        return this.type;
    }

    public void setType(ServiceNowBasicAuthType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    public ServiceNowBasicAuthUpdate username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonAnySetter
    public ServiceNowBasicAuthUpdate putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceNowBasicAuthUpdate serviceNowBasicAuthUpdate = (ServiceNowBasicAuthUpdate)o;
        return Objects.equals(this.instance, serviceNowBasicAuthUpdate.instance) && Objects.equals(this.password, serviceNowBasicAuthUpdate.password) && Objects.equals(this.type, serviceNowBasicAuthUpdate.type) && Objects.equals(this.username, serviceNowBasicAuthUpdate.username) && Objects.equals(this.additionalProperties, serviceNowBasicAuthUpdate.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.instance, this.password, this.type, this.username, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceNowBasicAuthUpdate {\n");
        sb.append("    instance: ").append(this.toIndentedString(this.instance)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

