/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.SensitiveDataScannerFilter;
import com.datadog.api.client.v2.model.SensitiveDataScannerProduct;
import com.datadog.api.client.v2.model.SensitiveDataScannerSamplings;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"description", "filter", "is_enabled", "name", "product_list", "samplings"})
public class SensitiveDataScannerGroupAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private SensitiveDataScannerFilter filter;
    public static final String JSON_PROPERTY_IS_ENABLED = "is_enabled";
    private Boolean isEnabled;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRODUCT_LIST = "product_list";
    private List<SensitiveDataScannerProduct> productList = null;
    public static final String JSON_PROPERTY_SAMPLINGS = "samplings";
    private List<SensitiveDataScannerSamplings> samplings = null;
    private Map<String, Object> additionalProperties;

    public SensitiveDataScannerGroupAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SensitiveDataScannerGroupAttributes filter(SensitiveDataScannerFilter filter) {
        this.filter = filter;
        this.unparsed |= filter.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SensitiveDataScannerFilter getFilter() {
        return this.filter;
    }

    public void setFilter(SensitiveDataScannerFilter filter) {
        this.filter = filter;
    }

    public SensitiveDataScannerGroupAttributes isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @Nullable
    @JsonProperty(value="is_enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public SensitiveDataScannerGroupAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SensitiveDataScannerGroupAttributes productList(List<SensitiveDataScannerProduct> productList) {
        this.productList = productList;
        return this;
    }

    public SensitiveDataScannerGroupAttributes addProductListItem(SensitiveDataScannerProduct productListItem) {
        if (this.productList == null) {
            this.productList = new ArrayList<SensitiveDataScannerProduct>();
        }
        this.productList.add(productListItem);
        this.unparsed |= !productListItem.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="product_list")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SensitiveDataScannerProduct> getProductList() {
        return this.productList;
    }

    public void setProductList(List<SensitiveDataScannerProduct> productList) {
        this.productList = productList;
    }

    public SensitiveDataScannerGroupAttributes samplings(List<SensitiveDataScannerSamplings> samplings) {
        this.samplings = samplings;
        for (SensitiveDataScannerSamplings item : samplings) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public SensitiveDataScannerGroupAttributes addSamplingsItem(SensitiveDataScannerSamplings samplingsItem) {
        if (this.samplings == null) {
            this.samplings = new ArrayList<SensitiveDataScannerSamplings>();
        }
        this.samplings.add(samplingsItem);
        this.unparsed |= samplingsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="samplings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SensitiveDataScannerSamplings> getSamplings() {
        return this.samplings;
    }

    public void setSamplings(List<SensitiveDataScannerSamplings> samplings) {
        this.samplings = samplings;
    }

    @JsonAnySetter
    public SensitiveDataScannerGroupAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SensitiveDataScannerGroupAttributes sensitiveDataScannerGroupAttributes = (SensitiveDataScannerGroupAttributes)o;
        return Objects.equals(this.description, sensitiveDataScannerGroupAttributes.description) && Objects.equals(this.filter, sensitiveDataScannerGroupAttributes.filter) && Objects.equals(this.isEnabled, sensitiveDataScannerGroupAttributes.isEnabled) && Objects.equals(this.name, sensitiveDataScannerGroupAttributes.name) && Objects.equals(this.productList, sensitiveDataScannerGroupAttributes.productList) && Objects.equals(this.samplings, sensitiveDataScannerGroupAttributes.samplings) && Objects.equals(this.additionalProperties, sensitiveDataScannerGroupAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.filter, this.isEnabled, this.name, this.productList, this.samplings, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SensitiveDataScannerGroupAttributes {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    productList: ").append(this.toIndentedString(this.productList)).append("\n");
        sb.append("    samplings: ").append(this.toIndentedString(this.samplings)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

