/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.OnCallNotificationRuleCategory;
import com.datadog.api.client.v2.model.OnCallNotificationRuleChannelSettings;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"category", "channel_settings", "delay_minutes"})
public class OnCallNotificationRuleAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private OnCallNotificationRuleCategory category = OnCallNotificationRuleCategory.HIGH_URGENCY;
    public static final String JSON_PROPERTY_CHANNEL_SETTINGS = "channel_settings";
    private OnCallNotificationRuleChannelSettings channelSettings;
    public static final String JSON_PROPERTY_DELAY_MINUTES = "delay_minutes";
    private Long delayMinutes;
    private Map<String, Object> additionalProperties;

    public OnCallNotificationRuleAttributes category(OnCallNotificationRuleCategory category) {
        this.category = category;
        this.unparsed |= !category.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OnCallNotificationRuleCategory getCategory() {
        return this.category;
    }

    public void setCategory(OnCallNotificationRuleCategory category) {
        if (!category.isValid()) {
            this.unparsed = true;
        }
        this.category = category;
    }

    public OnCallNotificationRuleAttributes channelSettings(OnCallNotificationRuleChannelSettings channelSettings) {
        this.channelSettings = channelSettings;
        this.unparsed |= channelSettings.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="channel_settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OnCallNotificationRuleChannelSettings getChannelSettings() {
        return this.channelSettings;
    }

    public void setChannelSettings(OnCallNotificationRuleChannelSettings channelSettings) {
        this.channelSettings = channelSettings;
    }

    public OnCallNotificationRuleAttributes delayMinutes(Long delayMinutes) {
        this.delayMinutes = delayMinutes;
        return this;
    }

    @Nullable
    @JsonProperty(value="delay_minutes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getDelayMinutes() {
        return this.delayMinutes;
    }

    public void setDelayMinutes(Long delayMinutes) {
        this.delayMinutes = delayMinutes;
    }

    @JsonAnySetter
    public OnCallNotificationRuleAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OnCallNotificationRuleAttributes onCallNotificationRuleAttributes = (OnCallNotificationRuleAttributes)o;
        return Objects.equals(this.category, onCallNotificationRuleAttributes.category) && Objects.equals(this.channelSettings, onCallNotificationRuleAttributes.channelSettings) && Objects.equals(this.delayMinutes, onCallNotificationRuleAttributes.delayMinutes) && Objects.equals(this.additionalProperties, onCallNotificationRuleAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.channelSettings, this.delayMinutes, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OnCallNotificationRuleAttributes {\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    channelSettings: ").append(this.toIndentedString(this.channelSettings)).append("\n");
        sb.append("    delayMinutes: ").append(this.toIndentedString(this.delayMinutes)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

