/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.ObservabilityPipelineGcpAuth;
import com.datadog.api.client.v2.model.ObservabilityPipelineGoogleCloudStorageDestinationAcl;
import com.datadog.api.client.v2.model.ObservabilityPipelineGoogleCloudStorageDestinationStorageClass;
import com.datadog.api.client.v2.model.ObservabilityPipelineGoogleCloudStorageDestinationType;
import com.datadog.api.client.v2.model.ObservabilityPipelineMetadataEntry;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"acl", "auth", "bucket", "id", "inputs", "key_prefix", "metadata", "storage_class", "type"})
public class ObservabilityPipelineGoogleCloudStorageDestination {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ACL = "acl";
    private ObservabilityPipelineGoogleCloudStorageDestinationAcl acl;
    public static final String JSON_PROPERTY_AUTH = "auth";
    private ObservabilityPipelineGcpAuth auth;
    public static final String JSON_PROPERTY_BUCKET = "bucket";
    private String bucket;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INPUTS = "inputs";
    private List<String> inputs = new ArrayList<String>();
    public static final String JSON_PROPERTY_KEY_PREFIX = "key_prefix";
    private String keyPrefix;
    public static final String JSON_PROPERTY_METADATA = "metadata";
    private List<ObservabilityPipelineMetadataEntry> metadata = null;
    public static final String JSON_PROPERTY_STORAGE_CLASS = "storage_class";
    private ObservabilityPipelineGoogleCloudStorageDestinationStorageClass storageClass;
    public static final String JSON_PROPERTY_TYPE = "type";
    private ObservabilityPipelineGoogleCloudStorageDestinationType type = ObservabilityPipelineGoogleCloudStorageDestinationType.GOOGLE_CLOUD_STORAGE;
    private Map<String, Object> additionalProperties;

    public ObservabilityPipelineGoogleCloudStorageDestination() {
    }

    @JsonCreator
    public ObservabilityPipelineGoogleCloudStorageDestination(@JsonProperty(required=true, value="bucket") String bucket, @JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="inputs") List<String> inputs, @JsonProperty(required=true, value="storage_class") ObservabilityPipelineGoogleCloudStorageDestinationStorageClass storageClass, @JsonProperty(required=true, value="type") ObservabilityPipelineGoogleCloudStorageDestinationType type) {
        this.bucket = bucket;
        this.id = id;
        this.inputs = inputs;
        this.storageClass = storageClass;
        this.unparsed |= !storageClass.isValid();
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public ObservabilityPipelineGoogleCloudStorageDestination acl(ObservabilityPipelineGoogleCloudStorageDestinationAcl acl) {
        this.acl = acl;
        this.unparsed |= !acl.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="acl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ObservabilityPipelineGoogleCloudStorageDestinationAcl getAcl() {
        return this.acl;
    }

    public void setAcl(ObservabilityPipelineGoogleCloudStorageDestinationAcl acl) {
        if (!acl.isValid()) {
            this.unparsed = true;
        }
        this.acl = acl;
    }

    public ObservabilityPipelineGoogleCloudStorageDestination auth(ObservabilityPipelineGcpAuth auth) {
        this.auth = auth;
        this.unparsed |= auth.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="auth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ObservabilityPipelineGcpAuth getAuth() {
        return this.auth;
    }

    public void setAuth(ObservabilityPipelineGcpAuth auth) {
        this.auth = auth;
    }

    public ObservabilityPipelineGoogleCloudStorageDestination bucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    @JsonProperty(value="bucket")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public ObservabilityPipelineGoogleCloudStorageDestination id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ObservabilityPipelineGoogleCloudStorageDestination inputs(List<String> inputs) {
        this.inputs = inputs;
        return this;
    }

    public ObservabilityPipelineGoogleCloudStorageDestination addInputsItem(String inputsItem) {
        this.inputs.add(inputsItem);
        return this;
    }

    @JsonProperty(value="inputs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public ObservabilityPipelineGoogleCloudStorageDestination keyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
        return this;
    }

    @Nullable
    @JsonProperty(value="key_prefix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public ObservabilityPipelineGoogleCloudStorageDestination metadata(List<ObservabilityPipelineMetadataEntry> metadata) {
        this.metadata = metadata;
        for (ObservabilityPipelineMetadataEntry item : metadata) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public ObservabilityPipelineGoogleCloudStorageDestination addMetadataItem(ObservabilityPipelineMetadataEntry metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<ObservabilityPipelineMetadataEntry>();
        }
        this.metadata.add(metadataItem);
        this.unparsed |= metadataItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ObservabilityPipelineMetadataEntry> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<ObservabilityPipelineMetadataEntry> metadata) {
        this.metadata = metadata;
    }

    public ObservabilityPipelineGoogleCloudStorageDestination storageClass(ObservabilityPipelineGoogleCloudStorageDestinationStorageClass storageClass) {
        this.storageClass = storageClass;
        this.unparsed |= !storageClass.isValid();
        return this;
    }

    @JsonProperty(value="storage_class")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ObservabilityPipelineGoogleCloudStorageDestinationStorageClass getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(ObservabilityPipelineGoogleCloudStorageDestinationStorageClass storageClass) {
        if (!storageClass.isValid()) {
            this.unparsed = true;
        }
        this.storageClass = storageClass;
    }

    public ObservabilityPipelineGoogleCloudStorageDestination type(ObservabilityPipelineGoogleCloudStorageDestinationType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ObservabilityPipelineGoogleCloudStorageDestinationType getType() {
        return this.type;
    }

    public void setType(ObservabilityPipelineGoogleCloudStorageDestinationType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public ObservabilityPipelineGoogleCloudStorageDestination putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObservabilityPipelineGoogleCloudStorageDestination observabilityPipelineGoogleCloudStorageDestination = (ObservabilityPipelineGoogleCloudStorageDestination)o;
        return Objects.equals(this.acl, observabilityPipelineGoogleCloudStorageDestination.acl) && Objects.equals(this.auth, observabilityPipelineGoogleCloudStorageDestination.auth) && Objects.equals(this.bucket, observabilityPipelineGoogleCloudStorageDestination.bucket) && Objects.equals(this.id, observabilityPipelineGoogleCloudStorageDestination.id) && Objects.equals(this.inputs, observabilityPipelineGoogleCloudStorageDestination.inputs) && Objects.equals(this.keyPrefix, observabilityPipelineGoogleCloudStorageDestination.keyPrefix) && Objects.equals(this.metadata, observabilityPipelineGoogleCloudStorageDestination.metadata) && Objects.equals(this.storageClass, observabilityPipelineGoogleCloudStorageDestination.storageClass) && Objects.equals(this.type, observabilityPipelineGoogleCloudStorageDestination.type) && Objects.equals(this.additionalProperties, observabilityPipelineGoogleCloudStorageDestination.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.acl, this.auth, this.bucket, this.id, this.inputs, this.keyPrefix, this.metadata, this.storageClass, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ObservabilityPipelineGoogleCloudStorageDestination {\n");
        sb.append("    acl: ").append(this.toIndentedString(this.acl)).append("\n");
        sb.append("    auth: ").append(this.toIndentedString(this.auth)).append("\n");
        sb.append("    bucket: ").append(this.toIndentedString(this.bucket)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        sb.append("    keyPrefix: ").append(this.toIndentedString(this.keyPrefix)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    storageClass: ").append(this.toIndentedString(this.storageClass)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

