/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.InterfaceAttributesStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"alias", "description", "index", "ip_addresses", "mac_address", "name", "status"})
public class InterfaceAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ALIAS = "alias";
    private String alias;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_INDEX = "index";
    private Long index;
    public static final String JSON_PROPERTY_IP_ADDRESSES = "ip_addresses";
    private List<String> ipAddresses = null;
    public static final String JSON_PROPERTY_MAC_ADDRESS = "mac_address";
    private String macAddress;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_STATUS = "status";
    private InterfaceAttributesStatus status;
    private Map<String, Object> additionalProperties;

    public InterfaceAttributes alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Nullable
    @JsonProperty(value="alias")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public InterfaceAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public InterfaceAttributes index(Long index) {
        this.index = index;
        return this;
    }

    @Nullable
    @JsonProperty(value="index")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getIndex() {
        return this.index;
    }

    public void setIndex(Long index) {
        this.index = index;
    }

    public InterfaceAttributes ipAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
        return this;
    }

    public InterfaceAttributes addIpAddressesItem(String ipAddressesItem) {
        if (this.ipAddresses == null) {
            this.ipAddresses = new ArrayList<String>();
        }
        this.ipAddresses.add(ipAddressesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="ip_addresses")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public void setIpAddresses(List<String> ipAddresses) {
        this.ipAddresses = ipAddresses;
    }

    public InterfaceAttributes macAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    @Nullable
    @JsonProperty(value="mac_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public InterfaceAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InterfaceAttributes status(InterfaceAttributesStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public InterfaceAttributesStatus getStatus() {
        return this.status;
    }

    public void setStatus(InterfaceAttributesStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    @JsonAnySetter
    public InterfaceAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InterfaceAttributes interfaceAttributes = (InterfaceAttributes)o;
        return Objects.equals(this.alias, interfaceAttributes.alias) && Objects.equals(this.description, interfaceAttributes.description) && Objects.equals(this.index, interfaceAttributes.index) && Objects.equals(this.ipAddresses, interfaceAttributes.ipAddresses) && Objects.equals(this.macAddress, interfaceAttributes.macAddress) && Objects.equals(this.name, interfaceAttributes.name) && Objects.equals(this.status, interfaceAttributes.status) && Objects.equals(this.additionalProperties, interfaceAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.description, this.index, this.ipAddresses, this.macAddress, this.name, this.status, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InterfaceAttributes {\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    index: ").append(this.toIndentedString(this.index)).append("\n");
        sb.append("    ipAddresses: ").append(this.toIndentedString(this.ipAddresses)).append("\n");
        sb.append("    macAddress: ").append(this.toIndentedString(this.macAddress)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

