/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.IncidentTodoAssignee;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"assignees", "completed", "content", "created", "due_date", "incident_id", "modified"})
public class IncidentTodoAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ASSIGNEES = "assignees";
    private List<IncidentTodoAssignee> assignees = new ArrayList<IncidentTodoAssignee>();
    public static final String JSON_PROPERTY_COMPLETED = "completed";
    private JsonNullable<String> completed = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CONTENT = "content";
    private String content;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_DUE_DATE = "due_date";
    private JsonNullable<String> dueDate = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INCIDENT_ID = "incident_id";
    private String incidentId;
    public static final String JSON_PROPERTY_MODIFIED = "modified";
    private OffsetDateTime modified;
    private Map<String, Object> additionalProperties;

    public IncidentTodoAttributes() {
    }

    @JsonCreator
    public IncidentTodoAttributes(@JsonProperty(required=true, value="assignees") List<IncidentTodoAssignee> assignees, @JsonProperty(required=true, value="content") String content) {
        this.assignees = assignees;
        this.content = content;
    }

    public IncidentTodoAttributes assignees(List<IncidentTodoAssignee> assignees) {
        this.assignees = assignees;
        for (IncidentTodoAssignee item : assignees) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public IncidentTodoAttributes addAssigneesItem(IncidentTodoAssignee assigneesItem) {
        this.assignees.add(assigneesItem);
        this.unparsed |= assigneesItem.unparsed;
        return this;
    }

    @JsonProperty(value="assignees")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<IncidentTodoAssignee> getAssignees() {
        return this.assignees;
    }

    public void setAssignees(List<IncidentTodoAssignee> assignees) {
        this.assignees = assignees;
    }

    public IncidentTodoAttributes completed(String completed) {
        this.completed = JsonNullable.of((Object)completed);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getCompleted() {
        return (String)this.completed.orElse(null);
    }

    @JsonProperty(value="completed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCompleted_JsonNullable() {
        return this.completed;
    }

    @JsonProperty(value="completed")
    public void setCompleted_JsonNullable(JsonNullable<String> completed) {
        this.completed = completed;
    }

    public void setCompleted(String completed) {
        this.completed = JsonNullable.of((Object)completed);
    }

    public IncidentTodoAttributes content(String content) {
        this.content = content;
        return this;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Nullable
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public IncidentTodoAttributes dueDate(String dueDate) {
        this.dueDate = JsonNullable.of((Object)dueDate);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getDueDate() {
        return (String)this.dueDate.orElse(null);
    }

    @JsonProperty(value="due_date")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getDueDate_JsonNullable() {
        return this.dueDate;
    }

    @JsonProperty(value="due_date")
    public void setDueDate_JsonNullable(JsonNullable<String> dueDate) {
        this.dueDate = dueDate;
    }

    public void setDueDate(String dueDate) {
        this.dueDate = JsonNullable.of((Object)dueDate);
    }

    public IncidentTodoAttributes incidentId(String incidentId) {
        this.incidentId = incidentId;
        return this;
    }

    @Nullable
    @JsonProperty(value="incident_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIncidentId() {
        return this.incidentId;
    }

    public void setIncidentId(String incidentId) {
        this.incidentId = incidentId;
    }

    @Nullable
    @JsonProperty(value="modified")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModified() {
        return this.modified;
    }

    @JsonAnySetter
    public IncidentTodoAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentTodoAttributes incidentTodoAttributes = (IncidentTodoAttributes)o;
        return Objects.equals(this.assignees, incidentTodoAttributes.assignees) && Objects.equals(this.completed, incidentTodoAttributes.completed) && Objects.equals(this.content, incidentTodoAttributes.content) && Objects.equals(this.created, incidentTodoAttributes.created) && Objects.equals(this.dueDate, incidentTodoAttributes.dueDate) && Objects.equals(this.incidentId, incidentTodoAttributes.incidentId) && Objects.equals(this.modified, incidentTodoAttributes.modified) && Objects.equals(this.additionalProperties, incidentTodoAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.assignees, this.completed, this.content, this.created, this.dueDate, this.incidentId, this.modified, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncidentTodoAttributes {\n");
        sb.append("    assignees: ").append(this.toIndentedString(this.assignees)).append("\n");
        sb.append("    completed: ").append(this.toIndentedString(this.completed)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    dueDate: ").append(this.toIndentedString(this.dueDate)).append("\n");
        sb.append("    incidentId: ").append(this.toIndentedString(this.incidentId)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

