/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CustomFrameworkRequirement;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"handle", "icon_url", "name", "requirements", "version"})
public class FullCustomFrameworkDataAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_HANDLE = "handle";
    private String handle;
    public static final String JSON_PROPERTY_ICON_URL = "icon_url";
    private String iconUrl;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_REQUIREMENTS = "requirements";
    private List<CustomFrameworkRequirement> requirements = new ArrayList<CustomFrameworkRequirement>();
    public static final String JSON_PROPERTY_VERSION = "version";
    private String version;
    private Map<String, Object> additionalProperties;

    public FullCustomFrameworkDataAttributes() {
    }

    @JsonCreator
    public FullCustomFrameworkDataAttributes(@JsonProperty(required=true, value="handle") String handle, @JsonProperty(required=true, value="name") String name, @JsonProperty(required=true, value="requirements") List<CustomFrameworkRequirement> requirements, @JsonProperty(required=true, value="version") String version) {
        this.handle = handle;
        this.name = name;
        this.requirements = requirements;
        this.version = version;
    }

    public FullCustomFrameworkDataAttributes handle(String handle) {
        this.handle = handle;
        return this;
    }

    @JsonProperty(value="handle")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public FullCustomFrameworkDataAttributes iconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    @Nullable
    @JsonProperty(value="icon_url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public FullCustomFrameworkDataAttributes name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FullCustomFrameworkDataAttributes requirements(List<CustomFrameworkRequirement> requirements) {
        this.requirements = requirements;
        for (CustomFrameworkRequirement item : requirements) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FullCustomFrameworkDataAttributes addRequirementsItem(CustomFrameworkRequirement requirementsItem) {
        this.requirements.add(requirementsItem);
        this.unparsed |= requirementsItem.unparsed;
        return this;
    }

    @JsonProperty(value="requirements")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<CustomFrameworkRequirement> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(List<CustomFrameworkRequirement> requirements) {
        this.requirements = requirements;
    }

    public FullCustomFrameworkDataAttributes version(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @JsonAnySetter
    public FullCustomFrameworkDataAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FullCustomFrameworkDataAttributes fullCustomFrameworkDataAttributes = (FullCustomFrameworkDataAttributes)o;
        return Objects.equals(this.handle, fullCustomFrameworkDataAttributes.handle) && Objects.equals(this.iconUrl, fullCustomFrameworkDataAttributes.iconUrl) && Objects.equals(this.name, fullCustomFrameworkDataAttributes.name) && Objects.equals(this.requirements, fullCustomFrameworkDataAttributes.requirements) && Objects.equals(this.version, fullCustomFrameworkDataAttributes.version) && Objects.equals(this.additionalProperties, fullCustomFrameworkDataAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.handle, this.iconUrl, this.name, this.requirements, this.version, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FullCustomFrameworkDataAttributes {\n");
        sb.append("    handle: ").append(this.toIndentedString(this.handle)).append("\n");
        sb.append("    iconUrl: ").append(this.toIndentedString(this.iconUrl)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    requirements: ").append(this.toIndentedString(this.requirements)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

