/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.FleetAgentInfoDetails;
import com.datadog.api.client.v2.model.FleetConfigurationLayer;
import com.datadog.api.client.v2.model.FleetDetectedIntegration;
import com.datadog.api.client.v2.model.FleetIntegrationsByStatus;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"agent_infos", "configuration_files", "detected_integrations", "integrations"})
public class FleetAgentInfoAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_AGENT_INFOS = "agent_infos";
    private FleetAgentInfoDetails agentInfos;
    public static final String JSON_PROPERTY_CONFIGURATION_FILES = "configuration_files";
    private FleetConfigurationLayer configurationFiles;
    public static final String JSON_PROPERTY_DETECTED_INTEGRATIONS = "detected_integrations";
    private List<FleetDetectedIntegration> detectedIntegrations = null;
    public static final String JSON_PROPERTY_INTEGRATIONS = "integrations";
    private FleetIntegrationsByStatus integrations;
    private Map<String, Object> additionalProperties;

    public FleetAgentInfoAttributes agentInfos(FleetAgentInfoDetails agentInfos) {
        this.agentInfos = agentInfos;
        this.unparsed |= agentInfos.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="agent_infos")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FleetAgentInfoDetails getAgentInfos() {
        return this.agentInfos;
    }

    public void setAgentInfos(FleetAgentInfoDetails agentInfos) {
        this.agentInfos = agentInfos;
    }

    public FleetAgentInfoAttributes configurationFiles(FleetConfigurationLayer configurationFiles) {
        this.configurationFiles = configurationFiles;
        this.unparsed |= configurationFiles.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="configuration_files")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FleetConfigurationLayer getConfigurationFiles() {
        return this.configurationFiles;
    }

    public void setConfigurationFiles(FleetConfigurationLayer configurationFiles) {
        this.configurationFiles = configurationFiles;
    }

    public FleetAgentInfoAttributes detectedIntegrations(List<FleetDetectedIntegration> detectedIntegrations) {
        this.detectedIntegrations = detectedIntegrations;
        for (FleetDetectedIntegration item : detectedIntegrations) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public FleetAgentInfoAttributes addDetectedIntegrationsItem(FleetDetectedIntegration detectedIntegrationsItem) {
        if (this.detectedIntegrations == null) {
            this.detectedIntegrations = new ArrayList<FleetDetectedIntegration>();
        }
        this.detectedIntegrations.add(detectedIntegrationsItem);
        this.unparsed |= detectedIntegrationsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="detected_integrations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FleetDetectedIntegration> getDetectedIntegrations() {
        return this.detectedIntegrations;
    }

    public void setDetectedIntegrations(List<FleetDetectedIntegration> detectedIntegrations) {
        this.detectedIntegrations = detectedIntegrations;
    }

    public FleetAgentInfoAttributes integrations(FleetIntegrationsByStatus integrations) {
        this.integrations = integrations;
        this.unparsed |= integrations.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="integrations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FleetIntegrationsByStatus getIntegrations() {
        return this.integrations;
    }

    public void setIntegrations(FleetIntegrationsByStatus integrations) {
        this.integrations = integrations;
    }

    @JsonAnySetter
    public FleetAgentInfoAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FleetAgentInfoAttributes fleetAgentInfoAttributes = (FleetAgentInfoAttributes)o;
        return Objects.equals(this.agentInfos, fleetAgentInfoAttributes.agentInfos) && Objects.equals(this.configurationFiles, fleetAgentInfoAttributes.configurationFiles) && Objects.equals(this.detectedIntegrations, fleetAgentInfoAttributes.detectedIntegrations) && Objects.equals(this.integrations, fleetAgentInfoAttributes.integrations) && Objects.equals(this.additionalProperties, fleetAgentInfoAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.agentInfos, this.configurationFiles, this.detectedIntegrations, this.integrations, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetAgentInfoAttributes {\n");
        sb.append("    agentInfos: ").append(this.toIndentedString(this.agentInfos)).append("\n");
        sb.append("    configurationFiles: ").append(this.toIndentedString(this.configurationFiles)).append("\n");
        sb.append("    detectedIntegrations: ").append(this.toIndentedString(this.detectedIntegrations)).append("\n");
        sb.append("    integrations: ").append(this.toIndentedString(this.integrations)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

