/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.NotificationChannelEmailConfigType;
import com.datadog.api.client.v2.model.NotificationChannelEmailFormatType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"address", "formats", "type"})
public class CreateEmailNotificationChannelConfig {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private String address;
    public static final String JSON_PROPERTY_FORMATS = "formats";
    private List<NotificationChannelEmailFormatType> formats = new ArrayList<NotificationChannelEmailFormatType>();
    public static final String JSON_PROPERTY_TYPE = "type";
    private NotificationChannelEmailConfigType type = NotificationChannelEmailConfigType.EMAIL;
    private Map<String, Object> additionalProperties;

    public CreateEmailNotificationChannelConfig() {
    }

    @JsonCreator
    public CreateEmailNotificationChannelConfig(@JsonProperty(required=true, value="address") String address, @JsonProperty(required=true, value="formats") List<NotificationChannelEmailFormatType> formats, @JsonProperty(required=true, value="type") NotificationChannelEmailConfigType type) {
        this.address = address;
        this.formats = formats;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public CreateEmailNotificationChannelConfig address(String address) {
        this.address = address;
        return this;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public CreateEmailNotificationChannelConfig formats(List<NotificationChannelEmailFormatType> formats) {
        this.formats = formats;
        return this;
    }

    public CreateEmailNotificationChannelConfig addFormatsItem(NotificationChannelEmailFormatType formatsItem) {
        this.formats.add(formatsItem);
        this.unparsed |= !formatsItem.isValid();
        return this;
    }

    @JsonProperty(value="formats")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<NotificationChannelEmailFormatType> getFormats() {
        return this.formats;
    }

    public void setFormats(List<NotificationChannelEmailFormatType> formats) {
        this.formats = formats;
    }

    public CreateEmailNotificationChannelConfig type(NotificationChannelEmailConfigType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NotificationChannelEmailConfigType getType() {
        return this.type;
    }

    public void setType(NotificationChannelEmailConfigType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public CreateEmailNotificationChannelConfig putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateEmailNotificationChannelConfig createEmailNotificationChannelConfig = (CreateEmailNotificationChannelConfig)o;
        return Objects.equals(this.address, createEmailNotificationChannelConfig.address) && Objects.equals(this.formats, createEmailNotificationChannelConfig.formats) && Objects.equals(this.type, createEmailNotificationChannelConfig.type) && Objects.equals(this.additionalProperties, createEmailNotificationChannelConfig.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.formats, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateEmailNotificationChannelConfig {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    formats: ").append(this.toIndentedString(this.formats)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

