/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CasePriority;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"assignee_id", "description", "priority", "title"})
public class CreateCaseRequestDataAttributes {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ASSIGNEE_ID = "assignee_id";
    private String assigneeId;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_PRIORITY = "priority";
    private CasePriority priority = CasePriority.NOT_DEFINED;
    public static final String JSON_PROPERTY_TITLE = "title";
    private String title;
    private Map<String, Object> additionalProperties;

    public CreateCaseRequestDataAttributes assigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
        return this;
    }

    @Nullable
    @JsonProperty(value="assignee_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(String assigneeId) {
        this.assigneeId = assigneeId;
    }

    public CreateCaseRequestDataAttributes description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateCaseRequestDataAttributes priority(CasePriority priority) {
        this.priority = priority;
        this.unparsed |= !priority.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="priority")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CasePriority getPriority() {
        return this.priority;
    }

    public void setPriority(CasePriority priority) {
        if (!priority.isValid()) {
            this.unparsed = true;
        }
        this.priority = priority;
    }

    public CreateCaseRequestDataAttributes title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @JsonProperty(value="title")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonAnySetter
    public CreateCaseRequestDataAttributes putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateCaseRequestDataAttributes createCaseRequestDataAttributes = (CreateCaseRequestDataAttributes)o;
        return Objects.equals(this.assigneeId, createCaseRequestDataAttributes.assigneeId) && Objects.equals(this.description, createCaseRequestDataAttributes.description) && Objects.equals(this.priority, createCaseRequestDataAttributes.priority) && Objects.equals(this.title, createCaseRequestDataAttributes.title) && Objects.equals(this.additionalProperties, createCaseRequestDataAttributes.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.assigneeId, this.description, this.priority, this.title, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateCaseRequestDataAttributes {\n");
        sb.append("    assigneeId: ").append(this.toIndentedString(this.assigneeId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

