/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.CIAppResponseStatus;
import com.datadog.api.client.v2.model.CIAppWarning;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"elapsed", "request_id", "status", "warnings"})
public class CIAppResponseMetadata {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_ELAPSED = "elapsed";
    private Long elapsed;
    public static final String JSON_PROPERTY_REQUEST_ID = "request_id";
    private String requestId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private CIAppResponseStatus status;
    public static final String JSON_PROPERTY_WARNINGS = "warnings";
    private List<CIAppWarning> warnings = null;
    private Map<String, Object> additionalProperties;

    public CIAppResponseMetadata elapsed(Long elapsed) {
        this.elapsed = elapsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="elapsed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(Long elapsed) {
        this.elapsed = elapsed;
    }

    public CIAppResponseMetadata requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Nullable
    @JsonProperty(value="request_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public CIAppResponseMetadata status(CIAppResponseStatus status) {
        this.status = status;
        this.unparsed |= !status.isValid();
        return this;
    }

    @Nullable
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CIAppResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(CIAppResponseStatus status) {
        if (!status.isValid()) {
            this.unparsed = true;
        }
        this.status = status;
    }

    public CIAppResponseMetadata warnings(List<CIAppWarning> warnings) {
        this.warnings = warnings;
        for (CIAppWarning item : warnings) {
            this.unparsed |= item.unparsed;
        }
        return this;
    }

    public CIAppResponseMetadata addWarningsItem(CIAppWarning warningsItem) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<CIAppWarning>();
        }
        this.warnings.add(warningsItem);
        this.unparsed |= warningsItem.unparsed;
        return this;
    }

    @Nullable
    @JsonProperty(value="warnings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CIAppWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<CIAppWarning> warnings) {
        this.warnings = warnings;
    }

    @JsonAnySetter
    public CIAppResponseMetadata putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CIAppResponseMetadata ciAppResponseMetadata = (CIAppResponseMetadata)o;
        return Objects.equals(this.elapsed, ciAppResponseMetadata.elapsed) && Objects.equals(this.requestId, ciAppResponseMetadata.requestId) && Objects.equals(this.status, ciAppResponseMetadata.status) && Objects.equals(this.warnings, ciAppResponseMetadata.warnings) && Objects.equals(this.additionalProperties, ciAppResponseMetadata.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.elapsed, this.requestId, this.status, this.warnings, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CIAppResponseMetadata {\n");
        sb.append("    elapsed: ").append(this.toIndentedString(this.elapsed)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    warnings: ").append(this.toIndentedString(this.warnings)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

