/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AzureTenantType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"app_client_id", "client_secret", "custom_scopes", "tenant_id", "type"})
public class AzureTenantUpdate {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_APP_CLIENT_ID = "app_client_id";
    private String appClientId;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "client_secret";
    private String clientSecret;
    public static final String JSON_PROPERTY_CUSTOM_SCOPES = "custom_scopes";
    private String customScopes;
    public static final String JSON_PROPERTY_TENANT_ID = "tenant_id";
    private String tenantId;
    public static final String JSON_PROPERTY_TYPE = "type";
    private AzureTenantType type;
    private Map<String, Object> additionalProperties;

    public AzureTenantUpdate() {
    }

    @JsonCreator
    public AzureTenantUpdate(@JsonProperty(required=true, value="type") AzureTenantType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public AzureTenantUpdate appClientId(String appClientId) {
        this.appClientId = appClientId;
        return this;
    }

    @Nullable
    @JsonProperty(value="app_client_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppClientId() {
        return this.appClientId;
    }

    public void setAppClientId(String appClientId) {
        this.appClientId = appClientId;
    }

    public AzureTenantUpdate clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nullable
    @JsonProperty(value="client_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public AzureTenantUpdate customScopes(String customScopes) {
        this.customScopes = customScopes;
        return this;
    }

    @Nullable
    @JsonProperty(value="custom_scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomScopes() {
        return this.customScopes;
    }

    public void setCustomScopes(String customScopes) {
        this.customScopes = customScopes;
    }

    public AzureTenantUpdate tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @JsonProperty(value="tenant_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public AzureTenantUpdate type(AzureTenantType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AzureTenantType getType() {
        return this.type;
    }

    public void setType(AzureTenantType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public AzureTenantUpdate putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureTenantUpdate azureTenantUpdate = (AzureTenantUpdate)o;
        return Objects.equals(this.appClientId, azureTenantUpdate.appClientId) && Objects.equals(this.clientSecret, azureTenantUpdate.clientSecret) && Objects.equals(this.customScopes, azureTenantUpdate.customScopes) && Objects.equals(this.tenantId, azureTenantUpdate.tenantId) && Objects.equals(this.type, azureTenantUpdate.type) && Objects.equals(this.additionalProperties, azureTenantUpdate.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.appClientId, this.clientSecret, this.customScopes, this.tenantId, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureTenantUpdate {\n");
        sb.append("    appClientId: ").append(this.toIndentedString(this.appClientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    customScopes: ").append(this.toIndentedString(this.customScopes)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

