/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.model;

import com.datadog.api.client.v2.model.AzureStorageDestinationType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"blob_prefix", "container_name", "id", "inputs", "type"})
public class AzureStorageDestination {
    @JsonIgnore
    public boolean unparsed = false;
    public static final String JSON_PROPERTY_BLOB_PREFIX = "blob_prefix";
    private String blobPrefix;
    public static final String JSON_PROPERTY_CONTAINER_NAME = "container_name";
    private String containerName;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_INPUTS = "inputs";
    private List<String> inputs = new ArrayList<String>();
    public static final String JSON_PROPERTY_TYPE = "type";
    private AzureStorageDestinationType type = AzureStorageDestinationType.AZURE_STORAGE;
    private Map<String, Object> additionalProperties;

    public AzureStorageDestination() {
    }

    @JsonCreator
    public AzureStorageDestination(@JsonProperty(required=true, value="container_name") String containerName, @JsonProperty(required=true, value="id") String id, @JsonProperty(required=true, value="inputs") List<String> inputs, @JsonProperty(required=true, value="type") AzureStorageDestinationType type) {
        this.containerName = containerName;
        this.id = id;
        this.inputs = inputs;
        this.type = type;
        this.unparsed |= !type.isValid();
    }

    public AzureStorageDestination blobPrefix(String blobPrefix) {
        this.blobPrefix = blobPrefix;
        return this;
    }

    @Nullable
    @JsonProperty(value="blob_prefix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBlobPrefix() {
        return this.blobPrefix;
    }

    public void setBlobPrefix(String blobPrefix) {
        this.blobPrefix = blobPrefix;
    }

    public AzureStorageDestination containerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    @JsonProperty(value="container_name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(String containerName) {
        this.containerName = containerName;
    }

    public AzureStorageDestination id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AzureStorageDestination inputs(List<String> inputs) {
        this.inputs = inputs;
        return this;
    }

    public AzureStorageDestination addInputsItem(String inputsItem) {
        this.inputs.add(inputsItem);
        return this;
    }

    @JsonProperty(value="inputs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    public AzureStorageDestination type(AzureStorageDestinationType type) {
        this.type = type;
        this.unparsed |= !type.isValid();
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AzureStorageDestinationType getType() {
        return this.type;
    }

    public void setType(AzureStorageDestinationType type) {
        if (!type.isValid()) {
            this.unparsed = true;
        }
        this.type = type;
    }

    @JsonAnySetter
    public AzureStorageDestination putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureStorageDestination azureStorageDestination = (AzureStorageDestination)o;
        return Objects.equals(this.blobPrefix, azureStorageDestination.blobPrefix) && Objects.equals(this.containerName, azureStorageDestination.containerName) && Objects.equals(this.id, azureStorageDestination.id) && Objects.equals(this.inputs, azureStorageDestination.inputs) && Objects.equals(this.type, azureStorageDestination.type) && Objects.equals(this.additionalProperties, azureStorageDestination.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.blobPrefix, this.containerName, this.id, this.inputs, this.type, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureStorageDestination {\n");
        sb.append("    blobPrefix: ").append(this.toIndentedString(this.blobPrefix)).append("\n");
        sb.append("    containerName: ").append(this.toIndentedString(this.containerName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    inputs: ").append(this.toIndentedString(this.inputs)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append('}');
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

