/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.api.client.v2.api;

import com.datadog.api.client.ApiClient;
import com.datadog.api.client.ApiException;
import com.datadog.api.client.ApiResponse;
import com.datadog.api.client.Pair;
import com.datadog.api.client.v2.model.CreateOnCallNotificationRuleRequest;
import com.datadog.api.client.v2.model.CreateUserNotificationChannelRequest;
import com.datadog.api.client.v2.model.EscalationPolicy;
import com.datadog.api.client.v2.model.EscalationPolicyCreateRequest;
import com.datadog.api.client.v2.model.EscalationPolicyUpdateRequest;
import com.datadog.api.client.v2.model.ListNotificationChannelsResponse;
import com.datadog.api.client.v2.model.ListOnCallNotificationRulesResponse;
import com.datadog.api.client.v2.model.NotificationChannel;
import com.datadog.api.client.v2.model.OnCallNotificationRule;
import com.datadog.api.client.v2.model.Schedule;
import com.datadog.api.client.v2.model.ScheduleCreateRequest;
import com.datadog.api.client.v2.model.ScheduleUpdateRequest;
import com.datadog.api.client.v2.model.Shift;
import com.datadog.api.client.v2.model.TeamOnCallResponders;
import com.datadog.api.client.v2.model.TeamRoutingRules;
import com.datadog.api.client.v2.model.TeamRoutingRulesRequest;
import com.datadog.api.client.v2.model.UpdateOnCallNotificationRuleRequest;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;

public class OnCallApi {
    private ApiClient apiClient;

    public OnCallApi() {
        this(ApiClient.getDefaultApiClient());
    }

    public OnCallApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public EscalationPolicy createOnCallEscalationPolicy(EscalationPolicyCreateRequest body) throws ApiException {
        return this.createOnCallEscalationPolicyWithHttpInfo(body, new CreateOnCallEscalationPolicyOptionalParameters()).getData();
    }

    public CompletableFuture<EscalationPolicy> createOnCallEscalationPolicyAsync(EscalationPolicyCreateRequest body) {
        return this.createOnCallEscalationPolicyWithHttpInfoAsync(body, new CreateOnCallEscalationPolicyOptionalParameters()).thenApply(response -> (EscalationPolicy)response.getData());
    }

    public EscalationPolicy createOnCallEscalationPolicy(EscalationPolicyCreateRequest body, CreateOnCallEscalationPolicyOptionalParameters parameters) throws ApiException {
        return this.createOnCallEscalationPolicyWithHttpInfo(body, parameters).getData();
    }

    public CompletableFuture<EscalationPolicy> createOnCallEscalationPolicyAsync(EscalationPolicyCreateRequest body, CreateOnCallEscalationPolicyOptionalParameters parameters) {
        return this.createOnCallEscalationPolicyWithHttpInfoAsync(body, parameters).thenApply(response -> (EscalationPolicy)response.getData());
    }

    public ApiResponse<EscalationPolicy> createOnCallEscalationPolicyWithHttpInfo(EscalationPolicyCreateRequest body, CreateOnCallEscalationPolicyOptionalParameters parameters) throws ApiException {
        EscalationPolicyCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createOnCallEscalationPolicy");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/escalation-policies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.createOnCallEscalationPolicy", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EscalationPolicy>(){});
    }

    public CompletableFuture<ApiResponse<EscalationPolicy>> createOnCallEscalationPolicyWithHttpInfoAsync(EscalationPolicyCreateRequest body, CreateOnCallEscalationPolicyOptionalParameters parameters) {
        Invocation.Builder builder;
        EscalationPolicyCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<EscalationPolicy>> result = new CompletableFuture<ApiResponse<EscalationPolicy>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createOnCallEscalationPolicy"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/escalation-policies";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.createOnCallEscalationPolicy", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<EscalationPolicy>> result = new CompletableFuture<ApiResponse<EscalationPolicy>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EscalationPolicy>(){});
    }

    public Schedule createOnCallSchedule(ScheduleCreateRequest body) throws ApiException {
        return this.createOnCallScheduleWithHttpInfo(body, new CreateOnCallScheduleOptionalParameters()).getData();
    }

    public CompletableFuture<Schedule> createOnCallScheduleAsync(ScheduleCreateRequest body) {
        return this.createOnCallScheduleWithHttpInfoAsync(body, new CreateOnCallScheduleOptionalParameters()).thenApply(response -> (Schedule)response.getData());
    }

    public Schedule createOnCallSchedule(ScheduleCreateRequest body, CreateOnCallScheduleOptionalParameters parameters) throws ApiException {
        return this.createOnCallScheduleWithHttpInfo(body, parameters).getData();
    }

    public CompletableFuture<Schedule> createOnCallScheduleAsync(ScheduleCreateRequest body, CreateOnCallScheduleOptionalParameters parameters) {
        return this.createOnCallScheduleWithHttpInfoAsync(body, parameters).thenApply(response -> (Schedule)response.getData());
    }

    public ApiResponse<Schedule> createOnCallScheduleWithHttpInfo(ScheduleCreateRequest body, CreateOnCallScheduleOptionalParameters parameters) throws ApiException {
        ScheduleCreateRequest localVarPostBody = body;
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createOnCallSchedule");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/schedules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.createOnCallSchedule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Schedule>(){});
    }

    public CompletableFuture<ApiResponse<Schedule>> createOnCallScheduleWithHttpInfoAsync(ScheduleCreateRequest body, CreateOnCallScheduleOptionalParameters parameters) {
        Invocation.Builder builder;
        ScheduleCreateRequest localVarPostBody = body;
        if (body == null) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createOnCallSchedule"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/schedules";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.createOnCallSchedule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Schedule>(){});
    }

    public NotificationChannel createUserNotificationChannel(String userId, CreateUserNotificationChannelRequest body) throws ApiException {
        return this.createUserNotificationChannelWithHttpInfo(userId, body).getData();
    }

    public CompletableFuture<NotificationChannel> createUserNotificationChannelAsync(String userId, CreateUserNotificationChannelRequest body) {
        return this.createUserNotificationChannelWithHttpInfoAsync(userId, body).thenApply(response -> (NotificationChannel)response.getData());
    }

    public ApiResponse<NotificationChannel> createUserNotificationChannelWithHttpInfo(String userId, CreateUserNotificationChannelRequest body) throws ApiException {
        CreateUserNotificationChannelRequest localVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling createUserNotificationChannel");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createUserNotificationChannel");
        }
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-channels".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.createUserNotificationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationChannel>(){});
    }

    public CompletableFuture<ApiResponse<NotificationChannel>> createUserNotificationChannelWithHttpInfoAsync(String userId, CreateUserNotificationChannelRequest body) {
        Invocation.Builder builder;
        CreateUserNotificationChannelRequest localVarPostBody = body;
        if (userId == null) {
            CompletableFuture<ApiResponse<NotificationChannel>> result = new CompletableFuture<ApiResponse<NotificationChannel>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling createUserNotificationChannel"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<NotificationChannel>> result = new CompletableFuture<ApiResponse<NotificationChannel>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createUserNotificationChannel"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-channels".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.createUserNotificationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<NotificationChannel>> result = new CompletableFuture<ApiResponse<NotificationChannel>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationChannel>(){});
    }

    public OnCallNotificationRule createUserNotificationRule(String userId, CreateOnCallNotificationRuleRequest body) throws ApiException {
        return this.createUserNotificationRuleWithHttpInfo(userId, body).getData();
    }

    public CompletableFuture<OnCallNotificationRule> createUserNotificationRuleAsync(String userId, CreateOnCallNotificationRuleRequest body) {
        return this.createUserNotificationRuleWithHttpInfoAsync(userId, body).thenApply(response -> (OnCallNotificationRule)response.getData());
    }

    public ApiResponse<OnCallNotificationRule> createUserNotificationRuleWithHttpInfo(String userId, CreateOnCallNotificationRuleRequest body) throws ApiException {
        CreateOnCallNotificationRuleRequest localVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling createUserNotificationRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createUserNotificationRule");
        }
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-rules".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.createUserNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OnCallNotificationRule>(){});
    }

    public CompletableFuture<ApiResponse<OnCallNotificationRule>> createUserNotificationRuleWithHttpInfoAsync(String userId, CreateOnCallNotificationRuleRequest body) {
        Invocation.Builder builder;
        CreateOnCallNotificationRuleRequest localVarPostBody = body;
        if (userId == null) {
            CompletableFuture<ApiResponse<OnCallNotificationRule>> result = new CompletableFuture<ApiResponse<OnCallNotificationRule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling createUserNotificationRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<OnCallNotificationRule>> result = new CompletableFuture<ApiResponse<OnCallNotificationRule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling createUserNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-rules".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.createUserNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OnCallNotificationRule>> result = new CompletableFuture<ApiResponse<OnCallNotificationRule>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("POST", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OnCallNotificationRule>(){});
    }

    public void deleteOnCallEscalationPolicy(String policyId) throws ApiException {
        this.deleteOnCallEscalationPolicyWithHttpInfo(policyId);
    }

    public CompletableFuture<Void> deleteOnCallEscalationPolicyAsync(String policyId) {
        return this.deleteOnCallEscalationPolicyWithHttpInfoAsync(policyId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteOnCallEscalationPolicyWithHttpInfo(String policyId) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling deleteOnCallEscalationPolicy");
        }
        String localVarPath = "/api/v2/on-call/escalation-policies/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.deleteOnCallEscalationPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteOnCallEscalationPolicyWithHttpInfoAsync(String policyId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (policyId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'policyId' when calling deleteOnCallEscalationPolicy"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/escalation-policies/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.deleteOnCallEscalationPolicy", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteOnCallSchedule(String scheduleId) throws ApiException {
        this.deleteOnCallScheduleWithHttpInfo(scheduleId);
    }

    public CompletableFuture<Void> deleteOnCallScheduleAsync(String scheduleId) {
        return this.deleteOnCallScheduleWithHttpInfoAsync(scheduleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteOnCallScheduleWithHttpInfo(String scheduleId) throws ApiException {
        Object localVarPostBody = null;
        if (scheduleId == null) {
            throw new ApiException(400, "Missing the required parameter 'scheduleId' when calling deleteOnCallSchedule");
        }
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.deleteOnCallSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteOnCallScheduleWithHttpInfoAsync(String scheduleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (scheduleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'scheduleId' when calling deleteOnCallSchedule"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.deleteOnCallSchedule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteUserNotificationChannel(String userId, String channelId) throws ApiException {
        this.deleteUserNotificationChannelWithHttpInfo(userId, channelId);
    }

    public CompletableFuture<Void> deleteUserNotificationChannelAsync(String userId, String channelId) {
        return this.deleteUserNotificationChannelWithHttpInfoAsync(userId, channelId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteUserNotificationChannelWithHttpInfo(String userId, String channelId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteUserNotificationChannel");
        }
        if (channelId == null) {
            throw new ApiException(400, "Missing the required parameter 'channelId' when calling deleteUserNotificationChannel");
        }
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-channels/{channel_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{channel_id\\}", this.apiClient.escapeString(channelId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.deleteUserNotificationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteUserNotificationChannelWithHttpInfoAsync(String userId, String channelId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling deleteUserNotificationChannel"));
            return result;
        }
        if (channelId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'channelId' when calling deleteUserNotificationChannel"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-channels/{channel_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{channel_id\\}", this.apiClient.escapeString(channelId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.deleteUserNotificationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public void deleteUserNotificationRule(String userId, String ruleId) throws ApiException {
        this.deleteUserNotificationRuleWithHttpInfo(userId, ruleId);
    }

    public CompletableFuture<Void> deleteUserNotificationRuleAsync(String userId, String ruleId) {
        return this.deleteUserNotificationRuleWithHttpInfoAsync(userId, ruleId).thenApply(response -> (Void)response.getData());
    }

    public ApiResponse<Void> deleteUserNotificationRuleWithHttpInfo(String userId, String ruleId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling deleteUserNotificationRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteUserNotificationRule");
        }
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-rules/{rule_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.deleteUserNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public CompletableFuture<ApiResponse<Void>> deleteUserNotificationRuleWithHttpInfoAsync(String userId, String ruleId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling deleteUserNotificationRule"));
            return result;
        }
        if (ruleId == null) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling deleteUserNotificationRule"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-rules/{rule_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.deleteUserNotificationRule", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"*/*"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Void>> result = new CompletableFuture<ApiResponse<Void>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("DELETE", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, null);
    }

    public EscalationPolicy getOnCallEscalationPolicy(String policyId) throws ApiException {
        return this.getOnCallEscalationPolicyWithHttpInfo(policyId, new GetOnCallEscalationPolicyOptionalParameters()).getData();
    }

    public CompletableFuture<EscalationPolicy> getOnCallEscalationPolicyAsync(String policyId) {
        return this.getOnCallEscalationPolicyWithHttpInfoAsync(policyId, new GetOnCallEscalationPolicyOptionalParameters()).thenApply(response -> (EscalationPolicy)response.getData());
    }

    public EscalationPolicy getOnCallEscalationPolicy(String policyId, GetOnCallEscalationPolicyOptionalParameters parameters) throws ApiException {
        return this.getOnCallEscalationPolicyWithHttpInfo(policyId, parameters).getData();
    }

    public CompletableFuture<EscalationPolicy> getOnCallEscalationPolicyAsync(String policyId, GetOnCallEscalationPolicyOptionalParameters parameters) {
        return this.getOnCallEscalationPolicyWithHttpInfoAsync(policyId, parameters).thenApply(response -> (EscalationPolicy)response.getData());
    }

    public ApiResponse<EscalationPolicy> getOnCallEscalationPolicyWithHttpInfo(String policyId, GetOnCallEscalationPolicyOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling getOnCallEscalationPolicy");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/escalation-policies/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.getOnCallEscalationPolicy", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EscalationPolicy>(){});
    }

    public CompletableFuture<ApiResponse<EscalationPolicy>> getOnCallEscalationPolicyWithHttpInfoAsync(String policyId, GetOnCallEscalationPolicyOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (policyId == null) {
            CompletableFuture<ApiResponse<EscalationPolicy>> result = new CompletableFuture<ApiResponse<EscalationPolicy>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'policyId' when calling getOnCallEscalationPolicy"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/escalation-policies/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.getOnCallEscalationPolicy", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<EscalationPolicy>> result = new CompletableFuture<ApiResponse<EscalationPolicy>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EscalationPolicy>(){});
    }

    public Schedule getOnCallSchedule(String scheduleId) throws ApiException {
        return this.getOnCallScheduleWithHttpInfo(scheduleId, new GetOnCallScheduleOptionalParameters()).getData();
    }

    public CompletableFuture<Schedule> getOnCallScheduleAsync(String scheduleId) {
        return this.getOnCallScheduleWithHttpInfoAsync(scheduleId, new GetOnCallScheduleOptionalParameters()).thenApply(response -> (Schedule)response.getData());
    }

    public Schedule getOnCallSchedule(String scheduleId, GetOnCallScheduleOptionalParameters parameters) throws ApiException {
        return this.getOnCallScheduleWithHttpInfo(scheduleId, parameters).getData();
    }

    public CompletableFuture<Schedule> getOnCallScheduleAsync(String scheduleId, GetOnCallScheduleOptionalParameters parameters) {
        return this.getOnCallScheduleWithHttpInfoAsync(scheduleId, parameters).thenApply(response -> (Schedule)response.getData());
    }

    public ApiResponse<Schedule> getOnCallScheduleWithHttpInfo(String scheduleId, GetOnCallScheduleOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (scheduleId == null) {
            throw new ApiException(400, "Missing the required parameter 'scheduleId' when calling getOnCallSchedule");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.getOnCallSchedule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Schedule>(){});
    }

    public CompletableFuture<ApiResponse<Schedule>> getOnCallScheduleWithHttpInfoAsync(String scheduleId, GetOnCallScheduleOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (scheduleId == null) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'scheduleId' when calling getOnCallSchedule"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.getOnCallSchedule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Schedule>(){});
    }

    public TeamRoutingRules getOnCallTeamRoutingRules(String teamId) throws ApiException {
        return this.getOnCallTeamRoutingRulesWithHttpInfo(teamId, new GetOnCallTeamRoutingRulesOptionalParameters()).getData();
    }

    public CompletableFuture<TeamRoutingRules> getOnCallTeamRoutingRulesAsync(String teamId) {
        return this.getOnCallTeamRoutingRulesWithHttpInfoAsync(teamId, new GetOnCallTeamRoutingRulesOptionalParameters()).thenApply(response -> (TeamRoutingRules)response.getData());
    }

    public TeamRoutingRules getOnCallTeamRoutingRules(String teamId, GetOnCallTeamRoutingRulesOptionalParameters parameters) throws ApiException {
        return this.getOnCallTeamRoutingRulesWithHttpInfo(teamId, parameters).getData();
    }

    public CompletableFuture<TeamRoutingRules> getOnCallTeamRoutingRulesAsync(String teamId, GetOnCallTeamRoutingRulesOptionalParameters parameters) {
        return this.getOnCallTeamRoutingRulesWithHttpInfoAsync(teamId, parameters).thenApply(response -> (TeamRoutingRules)response.getData());
    }

    public ApiResponse<TeamRoutingRules> getOnCallTeamRoutingRulesWithHttpInfo(String teamId, GetOnCallTeamRoutingRulesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling getOnCallTeamRoutingRules");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/teams/{team_id}/routing-rules".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.getOnCallTeamRoutingRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamRoutingRules>(){});
    }

    public CompletableFuture<ApiResponse<TeamRoutingRules>> getOnCallTeamRoutingRulesWithHttpInfoAsync(String teamId, GetOnCallTeamRoutingRulesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (teamId == null) {
            CompletableFuture<ApiResponse<TeamRoutingRules>> result = new CompletableFuture<ApiResponse<TeamRoutingRules>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling getOnCallTeamRoutingRules"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/teams/{team_id}/routing-rules".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.getOnCallTeamRoutingRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamRoutingRules>> result = new CompletableFuture<ApiResponse<TeamRoutingRules>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamRoutingRules>(){});
    }

    public Shift getScheduleOnCallUser(String scheduleId) throws ApiException {
        return this.getScheduleOnCallUserWithHttpInfo(scheduleId, new GetScheduleOnCallUserOptionalParameters()).getData();
    }

    public CompletableFuture<Shift> getScheduleOnCallUserAsync(String scheduleId) {
        return this.getScheduleOnCallUserWithHttpInfoAsync(scheduleId, new GetScheduleOnCallUserOptionalParameters()).thenApply(response -> (Shift)response.getData());
    }

    public Shift getScheduleOnCallUser(String scheduleId, GetScheduleOnCallUserOptionalParameters parameters) throws ApiException {
        return this.getScheduleOnCallUserWithHttpInfo(scheduleId, parameters).getData();
    }

    public CompletableFuture<Shift> getScheduleOnCallUserAsync(String scheduleId, GetScheduleOnCallUserOptionalParameters parameters) {
        return this.getScheduleOnCallUserWithHttpInfoAsync(scheduleId, parameters).thenApply(response -> (Shift)response.getData());
    }

    public ApiResponse<Shift> getScheduleOnCallUserWithHttpInfo(String scheduleId, GetScheduleOnCallUserOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (scheduleId == null) {
            throw new ApiException(400, "Missing the required parameter 'scheduleId' when calling getScheduleOnCallUser");
        }
        String include = parameters.include;
        String filterAtTs = parameters.filterAtTs;
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}/on-call".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[at_ts]", filterAtTs));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.getScheduleOnCallUser", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Shift>(){});
    }

    public CompletableFuture<ApiResponse<Shift>> getScheduleOnCallUserWithHttpInfoAsync(String scheduleId, GetScheduleOnCallUserOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (scheduleId == null) {
            CompletableFuture<ApiResponse<Shift>> result = new CompletableFuture<ApiResponse<Shift>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'scheduleId' when calling getScheduleOnCallUser"));
            return result;
        }
        String include = parameters.include;
        String filterAtTs = parameters.filterAtTs;
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}/on-call".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "filter[at_ts]", filterAtTs));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.getScheduleOnCallUser", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Shift>> result = new CompletableFuture<ApiResponse<Shift>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Shift>(){});
    }

    public TeamOnCallResponders getTeamOnCallUsers(String teamId) throws ApiException {
        return this.getTeamOnCallUsersWithHttpInfo(teamId, new GetTeamOnCallUsersOptionalParameters()).getData();
    }

    public CompletableFuture<TeamOnCallResponders> getTeamOnCallUsersAsync(String teamId) {
        return this.getTeamOnCallUsersWithHttpInfoAsync(teamId, new GetTeamOnCallUsersOptionalParameters()).thenApply(response -> (TeamOnCallResponders)response.getData());
    }

    public TeamOnCallResponders getTeamOnCallUsers(String teamId, GetTeamOnCallUsersOptionalParameters parameters) throws ApiException {
        return this.getTeamOnCallUsersWithHttpInfo(teamId, parameters).getData();
    }

    public CompletableFuture<TeamOnCallResponders> getTeamOnCallUsersAsync(String teamId, GetTeamOnCallUsersOptionalParameters parameters) {
        return this.getTeamOnCallUsersWithHttpInfoAsync(teamId, parameters).thenApply(response -> (TeamOnCallResponders)response.getData());
    }

    public ApiResponse<TeamOnCallResponders> getTeamOnCallUsersWithHttpInfo(String teamId, GetTeamOnCallUsersOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling getTeamOnCallUsers");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/teams/{team_id}/on-call".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.getTeamOnCallUsers", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamOnCallResponders>(){});
    }

    public CompletableFuture<ApiResponse<TeamOnCallResponders>> getTeamOnCallUsersWithHttpInfoAsync(String teamId, GetTeamOnCallUsersOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (teamId == null) {
            CompletableFuture<ApiResponse<TeamOnCallResponders>> result = new CompletableFuture<ApiResponse<TeamOnCallResponders>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling getTeamOnCallUsers"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/teams/{team_id}/on-call".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.getTeamOnCallUsers", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamOnCallResponders>> result = new CompletableFuture<ApiResponse<TeamOnCallResponders>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamOnCallResponders>(){});
    }

    public NotificationChannel getUserNotificationChannel(String userId, String channelId) throws ApiException {
        return this.getUserNotificationChannelWithHttpInfo(userId, channelId).getData();
    }

    public CompletableFuture<NotificationChannel> getUserNotificationChannelAsync(String userId, String channelId) {
        return this.getUserNotificationChannelWithHttpInfoAsync(userId, channelId).thenApply(response -> (NotificationChannel)response.getData());
    }

    public ApiResponse<NotificationChannel> getUserNotificationChannelWithHttpInfo(String userId, String channelId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUserNotificationChannel");
        }
        if (channelId == null) {
            throw new ApiException(400, "Missing the required parameter 'channelId' when calling getUserNotificationChannel");
        }
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-channels/{channel_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{channel_id\\}", this.apiClient.escapeString(channelId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.getUserNotificationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationChannel>(){});
    }

    public CompletableFuture<ApiResponse<NotificationChannel>> getUserNotificationChannelWithHttpInfoAsync(String userId, String channelId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userId == null) {
            CompletableFuture<ApiResponse<NotificationChannel>> result = new CompletableFuture<ApiResponse<NotificationChannel>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling getUserNotificationChannel"));
            return result;
        }
        if (channelId == null) {
            CompletableFuture<ApiResponse<NotificationChannel>> result = new CompletableFuture<ApiResponse<NotificationChannel>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'channelId' when calling getUserNotificationChannel"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-channels/{channel_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{channel_id\\}", this.apiClient.escapeString(channelId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.getUserNotificationChannel", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<NotificationChannel>> result = new CompletableFuture<ApiResponse<NotificationChannel>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<NotificationChannel>(){});
    }

    public OnCallNotificationRule getUserNotificationRule(String userId, String ruleId) throws ApiException {
        return this.getUserNotificationRuleWithHttpInfo(userId, ruleId, new GetUserNotificationRuleOptionalParameters()).getData();
    }

    public CompletableFuture<OnCallNotificationRule> getUserNotificationRuleAsync(String userId, String ruleId) {
        return this.getUserNotificationRuleWithHttpInfoAsync(userId, ruleId, new GetUserNotificationRuleOptionalParameters()).thenApply(response -> (OnCallNotificationRule)response.getData());
    }

    public OnCallNotificationRule getUserNotificationRule(String userId, String ruleId, GetUserNotificationRuleOptionalParameters parameters) throws ApiException {
        return this.getUserNotificationRuleWithHttpInfo(userId, ruleId, parameters).getData();
    }

    public CompletableFuture<OnCallNotificationRule> getUserNotificationRuleAsync(String userId, String ruleId, GetUserNotificationRuleOptionalParameters parameters) {
        return this.getUserNotificationRuleWithHttpInfoAsync(userId, ruleId, parameters).thenApply(response -> (OnCallNotificationRule)response.getData());
    }

    public ApiResponse<OnCallNotificationRule> getUserNotificationRuleWithHttpInfo(String userId, String ruleId, GetUserNotificationRuleOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling getUserNotificationRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling getUserNotificationRule");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-rules/{rule_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.getUserNotificationRule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OnCallNotificationRule>(){});
    }

    public CompletableFuture<ApiResponse<OnCallNotificationRule>> getUserNotificationRuleWithHttpInfoAsync(String userId, String ruleId, GetUserNotificationRuleOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userId == null) {
            CompletableFuture<ApiResponse<OnCallNotificationRule>> result = new CompletableFuture<ApiResponse<OnCallNotificationRule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling getUserNotificationRule"));
            return result;
        }
        if (ruleId == null) {
            CompletableFuture<ApiResponse<OnCallNotificationRule>> result = new CompletableFuture<ApiResponse<OnCallNotificationRule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling getUserNotificationRule"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-rules/{rule_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.getUserNotificationRule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OnCallNotificationRule>> result = new CompletableFuture<ApiResponse<OnCallNotificationRule>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OnCallNotificationRule>(){});
    }

    public ListNotificationChannelsResponse listUserNotificationChannels(String userId) throws ApiException {
        return this.listUserNotificationChannelsWithHttpInfo(userId).getData();
    }

    public CompletableFuture<ListNotificationChannelsResponse> listUserNotificationChannelsAsync(String userId) {
        return this.listUserNotificationChannelsWithHttpInfoAsync(userId).thenApply(response -> (ListNotificationChannelsResponse)response.getData());
    }

    public ApiResponse<ListNotificationChannelsResponse> listUserNotificationChannelsWithHttpInfo(String userId) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listUserNotificationChannels");
        }
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-channels".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.listUserNotificationChannels", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListNotificationChannelsResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListNotificationChannelsResponse>> listUserNotificationChannelsWithHttpInfoAsync(String userId) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userId == null) {
            CompletableFuture<ApiResponse<ListNotificationChannelsResponse>> result = new CompletableFuture<ApiResponse<ListNotificationChannelsResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling listUserNotificationChannels"));
            return result;
        }
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-channels".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.listUserNotificationChannels", localVarPath, new ArrayList<Pair>(), localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListNotificationChannelsResponse>> result = new CompletableFuture<ApiResponse<ListNotificationChannelsResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListNotificationChannelsResponse>(){});
    }

    public ListOnCallNotificationRulesResponse listUserNotificationRules(String userId) throws ApiException {
        return this.listUserNotificationRulesWithHttpInfo(userId, new ListUserNotificationRulesOptionalParameters()).getData();
    }

    public CompletableFuture<ListOnCallNotificationRulesResponse> listUserNotificationRulesAsync(String userId) {
        return this.listUserNotificationRulesWithHttpInfoAsync(userId, new ListUserNotificationRulesOptionalParameters()).thenApply(response -> (ListOnCallNotificationRulesResponse)response.getData());
    }

    public ListOnCallNotificationRulesResponse listUserNotificationRules(String userId, ListUserNotificationRulesOptionalParameters parameters) throws ApiException {
        return this.listUserNotificationRulesWithHttpInfo(userId, parameters).getData();
    }

    public CompletableFuture<ListOnCallNotificationRulesResponse> listUserNotificationRulesAsync(String userId, ListUserNotificationRulesOptionalParameters parameters) {
        return this.listUserNotificationRulesWithHttpInfoAsync(userId, parameters).thenApply(response -> (ListOnCallNotificationRulesResponse)response.getData());
    }

    public ApiResponse<ListOnCallNotificationRulesResponse> listUserNotificationRulesWithHttpInfo(String userId, ListUserNotificationRulesOptionalParameters parameters) throws ApiException {
        Object localVarPostBody = null;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling listUserNotificationRules");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-rules".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.listUserNotificationRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListOnCallNotificationRulesResponse>(){});
    }

    public CompletableFuture<ApiResponse<ListOnCallNotificationRulesResponse>> listUserNotificationRulesWithHttpInfoAsync(String userId, ListUserNotificationRulesOptionalParameters parameters) {
        Invocation.Builder builder;
        Object localVarPostBody = null;
        if (userId == null) {
            CompletableFuture<ApiResponse<ListOnCallNotificationRulesResponse>> result = new CompletableFuture<ApiResponse<ListOnCallNotificationRulesResponse>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling listUserNotificationRules"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-rules".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.listUserNotificationRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<ListOnCallNotificationRulesResponse>> result = new CompletableFuture<ApiResponse<ListOnCallNotificationRulesResponse>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("GET", builder, localVarHeaderParams, new String[0], localVarPostBody, new HashMap<String, Object>(), false, new GenericType<ListOnCallNotificationRulesResponse>(){});
    }

    public TeamRoutingRules setOnCallTeamRoutingRules(String teamId, TeamRoutingRulesRequest body) throws ApiException {
        return this.setOnCallTeamRoutingRulesWithHttpInfo(teamId, body, new SetOnCallTeamRoutingRulesOptionalParameters()).getData();
    }

    public CompletableFuture<TeamRoutingRules> setOnCallTeamRoutingRulesAsync(String teamId, TeamRoutingRulesRequest body) {
        return this.setOnCallTeamRoutingRulesWithHttpInfoAsync(teamId, body, new SetOnCallTeamRoutingRulesOptionalParameters()).thenApply(response -> (TeamRoutingRules)response.getData());
    }

    public TeamRoutingRules setOnCallTeamRoutingRules(String teamId, TeamRoutingRulesRequest body, SetOnCallTeamRoutingRulesOptionalParameters parameters) throws ApiException {
        return this.setOnCallTeamRoutingRulesWithHttpInfo(teamId, body, parameters).getData();
    }

    public CompletableFuture<TeamRoutingRules> setOnCallTeamRoutingRulesAsync(String teamId, TeamRoutingRulesRequest body, SetOnCallTeamRoutingRulesOptionalParameters parameters) {
        return this.setOnCallTeamRoutingRulesWithHttpInfoAsync(teamId, body, parameters).thenApply(response -> (TeamRoutingRules)response.getData());
    }

    public ApiResponse<TeamRoutingRules> setOnCallTeamRoutingRulesWithHttpInfo(String teamId, TeamRoutingRulesRequest body, SetOnCallTeamRoutingRulesOptionalParameters parameters) throws ApiException {
        TeamRoutingRulesRequest localVarPostBody = body;
        if (teamId == null) {
            throw new ApiException(400, "Missing the required parameter 'teamId' when calling setOnCallTeamRoutingRules");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling setOnCallTeamRoutingRules");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/teams/{team_id}/routing-rules".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.setOnCallTeamRoutingRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamRoutingRules>(){});
    }

    public CompletableFuture<ApiResponse<TeamRoutingRules>> setOnCallTeamRoutingRulesWithHttpInfoAsync(String teamId, TeamRoutingRulesRequest body, SetOnCallTeamRoutingRulesOptionalParameters parameters) {
        Invocation.Builder builder;
        TeamRoutingRulesRequest localVarPostBody = body;
        if (teamId == null) {
            CompletableFuture<ApiResponse<TeamRoutingRules>> result = new CompletableFuture<ApiResponse<TeamRoutingRules>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'teamId' when calling setOnCallTeamRoutingRules"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<TeamRoutingRules>> result = new CompletableFuture<ApiResponse<TeamRoutingRules>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling setOnCallTeamRoutingRules"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/teams/{team_id}/routing-rules".replaceAll("\\{team_id\\}", this.apiClient.escapeString(teamId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.setOnCallTeamRoutingRules", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<TeamRoutingRules>> result = new CompletableFuture<ApiResponse<TeamRoutingRules>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<TeamRoutingRules>(){});
    }

    public EscalationPolicy updateOnCallEscalationPolicy(String policyId, EscalationPolicyUpdateRequest body) throws ApiException {
        return this.updateOnCallEscalationPolicyWithHttpInfo(policyId, body, new UpdateOnCallEscalationPolicyOptionalParameters()).getData();
    }

    public CompletableFuture<EscalationPolicy> updateOnCallEscalationPolicyAsync(String policyId, EscalationPolicyUpdateRequest body) {
        return this.updateOnCallEscalationPolicyWithHttpInfoAsync(policyId, body, new UpdateOnCallEscalationPolicyOptionalParameters()).thenApply(response -> (EscalationPolicy)response.getData());
    }

    public EscalationPolicy updateOnCallEscalationPolicy(String policyId, EscalationPolicyUpdateRequest body, UpdateOnCallEscalationPolicyOptionalParameters parameters) throws ApiException {
        return this.updateOnCallEscalationPolicyWithHttpInfo(policyId, body, parameters).getData();
    }

    public CompletableFuture<EscalationPolicy> updateOnCallEscalationPolicyAsync(String policyId, EscalationPolicyUpdateRequest body, UpdateOnCallEscalationPolicyOptionalParameters parameters) {
        return this.updateOnCallEscalationPolicyWithHttpInfoAsync(policyId, body, parameters).thenApply(response -> (EscalationPolicy)response.getData());
    }

    public ApiResponse<EscalationPolicy> updateOnCallEscalationPolicyWithHttpInfo(String policyId, EscalationPolicyUpdateRequest body, UpdateOnCallEscalationPolicyOptionalParameters parameters) throws ApiException {
        EscalationPolicyUpdateRequest localVarPostBody = body;
        if (policyId == null) {
            throw new ApiException(400, "Missing the required parameter 'policyId' when calling updateOnCallEscalationPolicy");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOnCallEscalationPolicy");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/escalation-policies/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.updateOnCallEscalationPolicy", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EscalationPolicy>(){});
    }

    public CompletableFuture<ApiResponse<EscalationPolicy>> updateOnCallEscalationPolicyWithHttpInfoAsync(String policyId, EscalationPolicyUpdateRequest body, UpdateOnCallEscalationPolicyOptionalParameters parameters) {
        Invocation.Builder builder;
        EscalationPolicyUpdateRequest localVarPostBody = body;
        if (policyId == null) {
            CompletableFuture<ApiResponse<EscalationPolicy>> result = new CompletableFuture<ApiResponse<EscalationPolicy>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'policyId' when calling updateOnCallEscalationPolicy"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<EscalationPolicy>> result = new CompletableFuture<ApiResponse<EscalationPolicy>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateOnCallEscalationPolicy"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/escalation-policies/{policy_id}".replaceAll("\\{policy_id\\}", this.apiClient.escapeString(policyId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.updateOnCallEscalationPolicy", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<EscalationPolicy>> result = new CompletableFuture<ApiResponse<EscalationPolicy>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<EscalationPolicy>(){});
    }

    public Schedule updateOnCallSchedule(String scheduleId, ScheduleUpdateRequest body) throws ApiException {
        return this.updateOnCallScheduleWithHttpInfo(scheduleId, body, new UpdateOnCallScheduleOptionalParameters()).getData();
    }

    public CompletableFuture<Schedule> updateOnCallScheduleAsync(String scheduleId, ScheduleUpdateRequest body) {
        return this.updateOnCallScheduleWithHttpInfoAsync(scheduleId, body, new UpdateOnCallScheduleOptionalParameters()).thenApply(response -> (Schedule)response.getData());
    }

    public Schedule updateOnCallSchedule(String scheduleId, ScheduleUpdateRequest body, UpdateOnCallScheduleOptionalParameters parameters) throws ApiException {
        return this.updateOnCallScheduleWithHttpInfo(scheduleId, body, parameters).getData();
    }

    public CompletableFuture<Schedule> updateOnCallScheduleAsync(String scheduleId, ScheduleUpdateRequest body, UpdateOnCallScheduleOptionalParameters parameters) {
        return this.updateOnCallScheduleWithHttpInfoAsync(scheduleId, body, parameters).thenApply(response -> (Schedule)response.getData());
    }

    public ApiResponse<Schedule> updateOnCallScheduleWithHttpInfo(String scheduleId, ScheduleUpdateRequest body, UpdateOnCallScheduleOptionalParameters parameters) throws ApiException {
        ScheduleUpdateRequest localVarPostBody = body;
        if (scheduleId == null) {
            throw new ApiException(400, "Missing the required parameter 'scheduleId' when calling updateOnCallSchedule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateOnCallSchedule");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.updateOnCallSchedule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Schedule>(){});
    }

    public CompletableFuture<ApiResponse<Schedule>> updateOnCallScheduleWithHttpInfoAsync(String scheduleId, ScheduleUpdateRequest body, UpdateOnCallScheduleOptionalParameters parameters) {
        Invocation.Builder builder;
        ScheduleUpdateRequest localVarPostBody = body;
        if (scheduleId == null) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'scheduleId' when calling updateOnCallSchedule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateOnCallSchedule"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/schedules/{schedule_id}".replaceAll("\\{schedule_id\\}", this.apiClient.escapeString(scheduleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.updateOnCallSchedule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<Schedule>> result = new CompletableFuture<ApiResponse<Schedule>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<Schedule>(){});
    }

    public OnCallNotificationRule updateUserNotificationRule(String userId, String ruleId, UpdateOnCallNotificationRuleRequest body) throws ApiException {
        return this.updateUserNotificationRuleWithHttpInfo(userId, ruleId, body, new UpdateUserNotificationRuleOptionalParameters()).getData();
    }

    public CompletableFuture<OnCallNotificationRule> updateUserNotificationRuleAsync(String userId, String ruleId, UpdateOnCallNotificationRuleRequest body) {
        return this.updateUserNotificationRuleWithHttpInfoAsync(userId, ruleId, body, new UpdateUserNotificationRuleOptionalParameters()).thenApply(response -> (OnCallNotificationRule)response.getData());
    }

    public OnCallNotificationRule updateUserNotificationRule(String userId, String ruleId, UpdateOnCallNotificationRuleRequest body, UpdateUserNotificationRuleOptionalParameters parameters) throws ApiException {
        return this.updateUserNotificationRuleWithHttpInfo(userId, ruleId, body, parameters).getData();
    }

    public CompletableFuture<OnCallNotificationRule> updateUserNotificationRuleAsync(String userId, String ruleId, UpdateOnCallNotificationRuleRequest body, UpdateUserNotificationRuleOptionalParameters parameters) {
        return this.updateUserNotificationRuleWithHttpInfoAsync(userId, ruleId, body, parameters).thenApply(response -> (OnCallNotificationRule)response.getData());
    }

    public ApiResponse<OnCallNotificationRule> updateUserNotificationRuleWithHttpInfo(String userId, String ruleId, UpdateOnCallNotificationRuleRequest body, UpdateUserNotificationRuleOptionalParameters parameters) throws ApiException {
        UpdateOnCallNotificationRuleRequest localVarPostBody = body;
        if (userId == null) {
            throw new ApiException(400, "Missing the required parameter 'userId' when calling updateUserNotificationRule");
        }
        if (ruleId == null) {
            throw new ApiException(400, "Missing the required parameter 'ruleId' when calling updateUserNotificationRule");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling updateUserNotificationRule");
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-rules/{rule_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        Invocation.Builder builder = this.apiClient.createBuilder("v2.OnCallApi.updateUserNotificationRule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        return this.apiClient.invokeAPI("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OnCallNotificationRule>(){});
    }

    public CompletableFuture<ApiResponse<OnCallNotificationRule>> updateUserNotificationRuleWithHttpInfoAsync(String userId, String ruleId, UpdateOnCallNotificationRuleRequest body, UpdateUserNotificationRuleOptionalParameters parameters) {
        Invocation.Builder builder;
        UpdateOnCallNotificationRuleRequest localVarPostBody = body;
        if (userId == null) {
            CompletableFuture<ApiResponse<OnCallNotificationRule>> result = new CompletableFuture<ApiResponse<OnCallNotificationRule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'userId' when calling updateUserNotificationRule"));
            return result;
        }
        if (ruleId == null) {
            CompletableFuture<ApiResponse<OnCallNotificationRule>> result = new CompletableFuture<ApiResponse<OnCallNotificationRule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'ruleId' when calling updateUserNotificationRule"));
            return result;
        }
        if (body == null) {
            CompletableFuture<ApiResponse<OnCallNotificationRule>> result = new CompletableFuture<ApiResponse<OnCallNotificationRule>>();
            result.completeExceptionally(new ApiException(400, "Missing the required parameter 'body' when calling updateUserNotificationRule"));
            return result;
        }
        String include = parameters.include;
        String localVarPath = "/api/v2/on-call/users/{user_id}/notification-rules/{rule_id}".replaceAll("\\{user_id\\}", this.apiClient.escapeString(userId.toString())).replaceAll("\\{rule_id\\}", this.apiClient.escapeString(ruleId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "include", include));
        try {
            builder = this.apiClient.createBuilder("v2.OnCallApi.updateUserNotificationRule", localVarPath, localVarQueryParams, localVarHeaderParams, new HashMap<String, String>(), new String[]{"application/json"}, new String[]{"apiKeyAuth", "appKeyAuth", "AuthZ"});
        }
        catch (ApiException ex) {
            CompletableFuture<ApiResponse<OnCallNotificationRule>> result = new CompletableFuture<ApiResponse<OnCallNotificationRule>>();
            result.completeExceptionally(ex);
            return result;
        }
        return this.apiClient.invokeAPIAsync("PUT", builder, localVarHeaderParams, new String[]{"application/json"}, localVarPostBody, new HashMap<String, Object>(), false, new GenericType<OnCallNotificationRule>(){});
    }

    public static class UpdateUserNotificationRuleOptionalParameters {
        private String include;

        public UpdateUserNotificationRuleOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class UpdateOnCallScheduleOptionalParameters {
        private String include;

        public UpdateOnCallScheduleOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class UpdateOnCallEscalationPolicyOptionalParameters {
        private String include;

        public UpdateOnCallEscalationPolicyOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class SetOnCallTeamRoutingRulesOptionalParameters {
        private String include;

        public SetOnCallTeamRoutingRulesOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class ListUserNotificationRulesOptionalParameters {
        private String include;

        public ListUserNotificationRulesOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class GetUserNotificationRuleOptionalParameters {
        private String include;

        public GetUserNotificationRuleOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class GetTeamOnCallUsersOptionalParameters {
        private String include;

        public GetTeamOnCallUsersOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class GetScheduleOnCallUserOptionalParameters {
        private String include;
        private String filterAtTs;

        public GetScheduleOnCallUserOptionalParameters include(String include) {
            this.include = include;
            return this;
        }

        public GetScheduleOnCallUserOptionalParameters filterAtTs(String filterAtTs) {
            this.filterAtTs = filterAtTs;
            return this;
        }
    }

    public static class GetOnCallTeamRoutingRulesOptionalParameters {
        private String include;

        public GetOnCallTeamRoutingRulesOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class GetOnCallScheduleOptionalParameters {
        private String include;

        public GetOnCallScheduleOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class GetOnCallEscalationPolicyOptionalParameters {
        private String include;

        public GetOnCallEscalationPolicyOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class CreateOnCallScheduleOptionalParameters {
        private String include;

        public CreateOnCallScheduleOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }

    public static class CreateOnCallEscalationPolicyOptionalParameters {
        private String include;

        public CreateOnCallEscalationPolicyOptionalParameters include(String include) {
            this.include = include;
            return this;
        }
    }
}

